/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.org.apache.zookeeper.server.alluxio.shaded.client.com.and;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.PrintWriter;

import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxn;

public class DirsCommand extends AbstractFourLetterCommand {

    public DirsCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        super(pw, serverCnxn);
    }

    @Override
    public void alluxio.shaded.client.com.andRun() throws IOException {
        if (!isZKServerRunning()) {
            pw.println(ZK_NOT_SERVING);
            return;
        }
        pw.println("datadir_size: " + zkServer.getDataDirSize());
        pw.println("logdir_size: " + zkServer.getLogDirSize());
    }
}
