/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in alluxio.shaded.client.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.alluxio.shaded.client.com.google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Ascii}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.CaseFormat}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.CharMatcher}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Charsets}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Joiner}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Splitter}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Function}, {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Functions}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Predicate}, {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Predicates}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Equivalence}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Converter}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Supplier}, {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Defaults}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Enums}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Objects}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Optional}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Stopwatch}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base;

import alluxio.shaded.client.com.google.errorprone.annotations.CheckReturnValue;
import alluxio.shaded.client.javax.annotation.ParametersAreNonnullByDefault;
