/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.path.PathConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.Scope;
import alluxio.security.user.UserState;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.util.ConfigurationUtils;
import java.net.InetSocketAddress;
import java.util.HashMap;
import javax.security.auth.Subject;

public class ClientContext {
    private volatile AlluxioConfiguration mClusterConf;
    private volatile String mClusterConfHash;
    private volatile PathConfiguration mPathConf;
    private volatile UserState mUserState;
    private volatile String mPathConfHash;
    private volatile boolean mIsPathConfLoaded = false;
    private volatile boolean mUriValidationEnabled = true;

    public static ClientContext create(Subject subject, AlluxioConfiguration alluxioConf) {
        return new ClientContext(subject, alluxioConf);
    }

    public static ClientContext create(AlluxioConfiguration alluxioConf) {
        return new ClientContext(null, alluxioConf);
    }

    public static ClientContext create() {
        return new ClientContext(null, null);
    }

    protected ClientContext(ClientContext ctx) {
        this.mClusterConf = ctx.getClusterConf();
        this.mPathConf = ctx.getPathConf();
        this.mUserState = ctx.getUserState();
        this.mClusterConfHash = ctx.getClusterConfHash();
        this.mPathConfHash = ctx.getPathConfHash();
        this.mUriValidationEnabled = ctx.getUriValidationEnabled();
    }

    private ClientContext(@Nullable Subject subject, @Nullable AlluxioConfiguration alluxioConf) {
        if (subject == null) {
            subject = new Subject();
        }
        if (alluxioConf != null) {
            this.mClusterConf = new InstancedConfiguration(alluxioConf.copyProperties(), alluxioConf.clusterDefaultsLoaded());
            this.mClusterConfHash = alluxioConf.hash();
        } else {
            this.mClusterConf = new InstancedConfiguration(ConfigurationUtils.defaults());
            this.mClusterConfHash = this.mClusterConf.hash();
        }
        this.mPathConf = PathConfiguration.create(new HashMap<String, AlluxioConfiguration>());
        this.mUserState = UserState.Factory.create(this.mClusterConf, subject);
    }

    public synchronized void loadConf(InetSocketAddress address, boolean loadClusterConf, boolean loadPathConf) throws AlluxioStatusException {
        AlluxioConfiguration conf = this.mClusterConf;
        if (!loadClusterConf && !loadPathConf) {
            return;
        }
        GetConfigurationPResponse response = ConfigurationUtils.loadConfiguration(address, conf, !loadClusterConf, !loadPathConf);
        if (loadClusterConf) {
            this.mClusterConf = ConfigurationUtils.getClusterConf(response, conf, Scope.CLIENT);
            this.mClusterConfHash = response.getClusterConfigHash();
        }
        if (loadPathConf) {
            this.mPathConf = ConfigurationUtils.getPathConf(response, conf);
            this.mPathConfHash = response.getPathConfigHash();
            this.mIsPathConfLoaded = true;
        }
    }

    public synchronized void loadConfIfNotLoaded(InetSocketAddress address) throws AlluxioStatusException {
        if (!this.mClusterConf.getBoolean(PropertyKey.USER_CONF_CLUSTER_DEFAULT_ENABLED)) {
            return;
        }
        this.loadConf(address, !this.mClusterConf.clusterDefaultsLoaded(), !this.mIsPathConfLoaded);
        this.mUserState = UserState.Factory.create(this.mClusterConf, this.mUserState.getSubject());
    }

    public ClientContext setUriValidationEnabled(boolean uriValidationEnabled) {
        this.mUriValidationEnabled = uriValidationEnabled;
        return this;
    }

    public boolean getUriValidationEnabled() {
        return this.mUriValidationEnabled;
    }

    public AlluxioConfiguration getClusterConf() {
        return this.mClusterConf;
    }

    public PathConfiguration getPathConf() {
        return this.mPathConf;
    }

    public String getClusterConfHash() {
        return this.mClusterConfHash;
    }

    public String getPathConfHash() {
        return this.mPathConfHash;
    }

    public Subject getSubject() {
        return this.mUserState.getSubject();
    }

    public UserState getUserState() {
        return this.mUserState;
    }
}

