/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.security.authentication.AuthType;
import alluxio.security.login.AlluxioLoginModule;
import alluxio.security.login.AppLoginModule;
import alluxio.security.login.LoginModuleConfigurationUtils;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@ThreadSafe
public final class LoginModuleConfiguration
extends Configuration {
    private static final Map<String, String> EMPTY_JAAS_OPTIONS = new HashMap<String, String>();
    private static final AppConfigurationEntry OS_SPECIFIC_LOGIN = new AppConfigurationEntry(LoginModuleConfigurationUtils.OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, EMPTY_JAAS_OPTIONS);
    private static final AppConfigurationEntry APP_LOGIN = new AppConfigurationEntry(AppLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, EMPTY_JAAS_OPTIONS);
    private static final AppConfigurationEntry ALLUXIO_LOGIN = new AppConfigurationEntry(AlluxioLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, EMPTY_JAAS_OPTIONS);
    private static final AppConfigurationEntry[] SIMPLE = new AppConfigurationEntry[]{APP_LOGIN, OS_SPECIFIC_LOGIN, ALLUXIO_LOGIN};

    @Override
    @Nullable
    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (appName.equalsIgnoreCase(AuthType.SIMPLE.getAuthName()) || appName.equalsIgnoreCase(AuthType.CUSTOM.getAuthName())) {
            return SIMPLE;
        }
        if (appName.equalsIgnoreCase(AuthType.KERBEROS.getAuthName())) {
            throw new UnsupportedOperationException("Kerberos is not supported currently.");
        }
        return null;
    }
}

