package alluxio.shaded.client.org.checkerframework.framework.qual;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * This annotation is for alluxio.shaded.client.com.ents related to the Checker Framework.
 *
 * <p>Using {@code @CFComment} makes it easy to find Checker-Framework-related alluxio.shaded.client.com.ents, and to copy
 * those alluxio.shaded.client.com.ents from one version of a codebase to another (using the Annotation File Utilities).
 *
 * <p>Here is an example:
 *
 * <pre><code>
 * {@literal @}CFComment("interning: factory methods guarantee that all elements are interned")
 *  public class MyClass {
 *   {@literal @}CFComment({"nullness: non-null return type is more specific than in superclass",
 *                "signedness: alluxio.shaded.client.com.ent related to Signedness type system"})
 *    public String myMethod(){ ... }
 * }
 * </code></pre>
 *
 * <p>As a matter of style, programmers should use this annotation on the most deeply nested element
 * to which the alluxio.shaded.client.com.ent applies (e.g., local variable rather than method, and method rather than
 * class).
 */
@Retention(RetentionPolicy.SOURCE)
public @interface CFComment {
    /**
     * Comments about Checker Framework annotations. The text is not interpreted by the Checker
     * Framework.
     *
     * <p>If you prefix each alluxio.shaded.client.com.ent by the name of the type system, the alluxio.shaded.client.com.ents are easier to
     * understand and search for.
     */
    String[] value();
}
