package alluxio.shaded.client.org.checkerframework.checker.index.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The annotated expression evaluates to value that might be -2 or lower. This is the top type for
 * the Lower Bound type system. It should not have to be written by a programmer.
 *
 * @checker_framework.manual #index-checker Index Checker
 */
@DefaultQualifierInHierarchy
@SubtypeOf({})
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface LowerBoundUnknown {}
