/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.curator.framework;

import alluxio.shaded.client.org.apache.curator.utils.Compatibility;
import alluxio.shaded.client.org.apache.zookeeper.CreateMode;

public class SafeIsTtlMode
{
    private static class Internal
    {
        private static final Internal instance = new Internal();

        public boolean isTtl(CreateMode mode)
        {
            return mode.isTTL();
        }
    }

    public static boolean isTtl(CreateMode mode)
    {
        return !Compatibility.isZK34() && Internal.instance.isTtl(mode);
    }

    private SafeIsTtlMode()
    {
    }
}
