/*
 * Copyright 2019 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.netty;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.internal.ObjectPool;
import alluxio.shaded.client.io.netty.channel.ChannelHandler;
import alluxio.shaded.client.io.netty.util.AsciiString;
import java.util.concurrent.Executor;

/**
 * Internal accessor for {@link ProtocolNegotiator}.
 */
@Internal
public final class InternalProtocolNegotiator {

  private InternalProtocolNegotiator() {}

  public interface ProtocolNegotiator extends alluxio.shaded.client.io.grpc.netty.ProtocolNegotiator {}

  static final class ProtocolNegotiatorAdapter
      implements InternalProtocolNegotiator.ProtocolNegotiator {
    private final alluxio.shaded.client.io.grpc.netty.ProtocolNegotiator negotiator;

    public ProtocolNegotiatorAdapter(alluxio.shaded.client.io.grpc.netty.ProtocolNegotiator negotiator) {
      this.negotiator = Preconditions.checkNotNull(negotiator, "negotiator");
    }

    @Override
    public AsciiString scheme() {
      return negotiator.scheme();
    }

    @Override
    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
      return negotiator.newHandler(grpcHandler);
    }

    @Override
    public void close() {
      negotiator.close();
    }
  }

  public interface ClientFactory extends alluxio.shaded.client.io.grpc.netty.ProtocolNegotiator.ClientFactory {
    @Override ProtocolNegotiator newNegotiator();
  }

  public interface ServerFactory extends alluxio.shaded.client.io.grpc.netty.ProtocolNegotiator.ServerFactory {
    @Override ProtocolNegotiator newNegotiator(ObjectPool<? extends Executor> offloadExecutorPool);
  }
}
