/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.underfs.UfsStatus;
import java.util.Map;

@NotThreadSafe
public class UfsFileStatus
extends UfsStatus {
    public static final String INVALID_CONTENT_HASH = "";
    public static final long UNKNOWN_BLOCK_SIZE = -1L;
    protected final String mContentHash;
    protected final long mContentLength;
    protected final long mBlockSize;

    public UfsFileStatus(String name, String contentHash, long contentLength, long lastModifiedTimeMs, String owner, String group, short mode, @Nullable Map<String, byte[]> xAttr, long blockSize) {
        super(name, false, owner, group, mode, lastModifiedTimeMs, xAttr);
        this.mContentHash = contentHash;
        this.mContentLength = contentLength;
        this.mBlockSize = blockSize;
    }

    public UfsFileStatus(String name, String contentHash, long contentLength, long lastModifiedTimeMs, String owner, String group, short mode, long blockSize) {
        super(name, false, owner, group, mode, lastModifiedTimeMs, null);
        this.mContentHash = contentHash;
        this.mContentLength = contentLength;
        this.mBlockSize = blockSize;
    }

    @Deprecated
    public UfsFileStatus(String name, String contentHash, long contentLength, long lastModifiedTimeMs, String owner, String group, short mode, @Nullable Map<String, byte[]> xAttr) {
        this(name, contentHash, contentLength, lastModifiedTimeMs, owner, group, mode, xAttr, -1L);
    }

    @Deprecated
    public UfsFileStatus(String name, String contentHash, long contentLength, long lastModifiedTimeMs, String owner, String group, short mode) {
        this(name, contentHash, contentLength, lastModifiedTimeMs, owner, group, mode, null, -1L);
    }

    public UfsFileStatus(UfsFileStatus status) {
        super(status);
        this.mContentHash = status.mContentHash;
        this.mContentLength = status.mContentLength;
        this.mBlockSize = status.mBlockSize;
    }

    @Override
    public UfsFileStatus copy() {
        return new UfsFileStatus(this);
    }

    public String getContentHash() {
        return this.mContentHash;
    }

    public long getContentLength() {
        return this.mContentLength;
    }

    public long getBlockSize() {
        return this.mBlockSize;
    }

    public String toString() {
        return this.toStringHelper().add("contentHash", this.mContentHash).add("contentLength", this.mContentLength).toString();
    }
}

