/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.curator.utils;

import alluxio.shaded.client.org.apache.curator.drivers.TracerDriver;
import alluxio.shaded.client.org.slf4j.Logger;
import alluxio.shaded.client.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

/**
 * Default tracer driver
 */
public class DefaultTracerDriver implements TracerDriver
{
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void addTrace(String name, long time, TimeUnit unit)
    {
        if ( log.isTraceEnabled() )
        {
            log.trace("Trace: " + name + " - " + TimeUnit.MILLISECONDS.convert(time, unit) + " ms");
        }
    }

    @Override
    public void addCount(String name, int increment)
    {
        if ( log.isTraceEnabled() )
        {
            log.trace("Counter " + name + ": " + increment);
        }
    }
}
