/*
 * Copyright (C) 2018 The Gson authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.gson.internal;

/**
 * Build configuration for Gson. This file is automatically populated by
 * templating-maven-plugin and .java/.class files are generated for use in Gson.
 *
 * @author Inderjeet Singh
 */
public final class GsonBuildConfig {
  // Based on https://stackoverflow.alluxio.shaded.client.com.questions/2469922/generate-a-version-java-file-in-maven

  /** This field is automatically populated by Maven when a build is triggered */
  public static final String VERSION = "2.8.6";

  private GsonBuildConfig() { }
}
