/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheEvictor;
import alluxio.client.file.cache.MetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetaStore
implements MetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetaStore.class);
    private final Map<PageId, PageInfo> mPageMap = new HashMap<PageId, PageInfo>();
    private final AtomicLong mBytes = new AtomicLong(0L);
    private final AtomicLong mPages = new AtomicLong(0L);
    private final CacheEvictor mEvictor;

    public DefaultMetaStore(AlluxioConfiguration conf) {
        this(CacheEvictor.create(conf));
    }

    @VisibleForTesting
    public DefaultMetaStore(CacheEvictor evictor) {
        this.mEvictor = evictor;
    }

    @Override
    public boolean hasPage(PageId pageId) {
        return this.mPageMap.containsKey(pageId);
    }

    @Override
    public void addPage(PageId pageId, PageInfo pageInfo) {
        this.mPageMap.put(pageId, pageInfo);
        this.mBytes.addAndGet(pageInfo.getPageSize());
        Metrics.SPACE_USED.inc(pageInfo.getPageSize());
        this.mPages.incrementAndGet();
        Metrics.PAGES.inc();
        this.mEvictor.updateOnPut(pageId);
    }

    @Override
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        this.mEvictor.updateOnGet(pageId);
        return this.mPageMap.get(pageId);
    }

    @Override
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        if (!this.mPageMap.containsKey(pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPageMap.remove(pageId);
        this.mBytes.addAndGet(-pageInfo.getPageSize());
        Metrics.SPACE_USED.dec(pageInfo.getPageSize());
        this.mPages.decrementAndGet();
        Metrics.PAGES.dec();
        this.mEvictor.updateOnDelete(pageId);
        return pageInfo;
    }

    @Override
    public long bytes() {
        return this.mBytes.get();
    }

    @Override
    public long pages() {
        return this.mPages.get();
    }

    @Override
    public void reset() {
        this.mPages.set(0L);
        Metrics.PAGES.dec(Metrics.PAGES.getCount());
        this.mBytes.set(0L);
        Metrics.SPACE_USED.dec(Metrics.SPACE_USED.getCount());
        this.mPageMap.clear();
        this.mEvictor.reset();
    }

    @Override
    @Nullable
    public PageInfo evict() {
        return this.evictInternal(this.mEvictor);
    }

    PageInfo evictInternal(CacheEvictor evictor) {
        PageId victim = evictor.evict();
        if (victim == null) {
            return null;
        }
        PageInfo victimInfo = this.mPageMap.get(victim);
        if (victimInfo == null) {
            LOG.error("Invalid result returned by evictor: page {} not available", (Object)victim);
            evictor.updateOnDelete(victim);
            return null;
        }
        return victimInfo;
    }

    private static final class Metrics {
        private static final Counter SPACE_USED = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SPACE_USED_COUNT.getName());
        private static final Counter PAGES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PAGES.getName());

        private Metrics() {
        }
    }
}

