/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.reflections.scanners;

import alluxio.shaded.client.org.reflections.Configuration;
import alluxio.shaded.client.org.reflections.ReflectionsException;
import alluxio.shaded.client.org.reflections.Store;
import alluxio.shaded.client.org.reflections.adapters.MetadataAdapter;
import alluxio.shaded.client.org.reflections.scanners.Scanner;
import alluxio.shaded.client.org.reflections.util.Utils;
import alluxio.shaded.client.org.reflections.vfs.Vfs;
import java.util.function.Predicate;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Predicate<String> resultFilter = s2 -> true;

    @Override
    public boolean acceptsInput(String file) {
        return this.getMetadataAdapter().acceptsInput(file);
    }

    @Override
    public Object scan(Vfs.File file, Object classObject, Store store) {
        if (classObject == null) {
            try {
                classObject = this.configuration.getMetadataAdapter().getOrCreateClassObject(file);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        this.scan(classObject, store);
        return classObject;
    }

    public abstract void scan(Object var1, Store var2);

    protected void put(Store store, String key, String value) {
        store.put(Utils.index(this.getClass()), key, value);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter);
        return this;
    }

    @Override
    public boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.test(fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

