/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.worker.block.io.BlockReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

@NotThreadSafe
public class LocalFileBlockReader
extends BlockReader {
    private final String mFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();
    private final long mFileSize;
    private boolean mClosed;
    private int mUsageCount = 0;

    public LocalFileBlockReader(String path) throws IOException {
        this.mFilePath = Preconditions.checkNotNull(path, "path");
        this.mLocalFile = this.mCloser.register(new RandomAccessFile(this.mFilePath, "r"));
        this.mFileSize = this.mLocalFile.length();
        this.mLocalFileChannel = this.mCloser.register(this.mLocalFile.getChannel());
    }

    @Override
    public ReadableByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public long getLength() {
        return this.mFileSize;
    }

    public void increaseUsageCount() {
        ++this.mUsageCount;
    }

    public void decreaseUsageCount() {
        Preconditions.checkState(this.mUsageCount > 0);
        --this.mUsageCount;
    }

    public int getUsageCount() {
        return this.mUsageCount;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    @Override
    public ByteBuffer read(long offset, long length) throws IOException {
        Preconditions.checkArgument(offset + length <= this.mFileSize, "offset=%s, length=%s, exceeding fileSize=%s", (Object)offset, (Object)length, (Object)this.mFileSize);
        if (length == -1L) {
            length = this.mFileSize - offset;
        }
        return this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
    }

    @Override
    public int transferTo(ByteBuf buf) throws IOException {
        return buf.writeBytes(this.mLocalFileChannel, buf.writableBytes());
    }

    @Override
    public void close() throws IOException {
        super.close();
        Preconditions.checkState(this.mUsageCount == 0);
        if (this.mClosed) {
            return;
        }
        try {
            this.mCloser.close();
        }
        finally {
            this.mClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public String getLocation() {
        return this.mFilePath;
    }
}

