/*
 * Copyright 2016 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.netty;

import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.InternalChannelz;
import alluxio.shaded.client.io.netty.channel.ChannelPromise;
import alluxio.shaded.client.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import alluxio.shaded.client.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import alluxio.shaded.client.io.netty.handler.codec.http2.Http2ConnectionHandler;
import alluxio.shaded.client.io.netty.handler.codec.http2.Http2Settings;
import alluxio.shaded.client.javax.annotation.Nullable;

/**
 * gRPC wrapper for {@link Http2ConnectionHandler}.
 */
@Internal
public abstract class GrpcHttp2ConnectionHandler extends Http2ConnectionHandler {

  @Nullable
  protected final ChannelPromise channelUnused;

  public GrpcHttp2ConnectionHandler(
      ChannelPromise channelUnused,
      Http2ConnectionDecoder decoder,
      Http2ConnectionEncoder encoder,
      Http2Settings initialSettings) {
    super(decoder, encoder, initialSettings);
    this.channelUnused = channelUnused;
  }

  /**
   * Same as {@link #handleProtocolNegotiationCompleted(
   *   Attributes, alluxio.shaded.client.io.grpc.InternalChannelz.Security)}
   * but with no {@link alluxio.shaded.client.io.grpc.InternalChannelz.Security}.
   *
   * @deprecated Use the two argument method instead.
   */
  @Deprecated
  public void handleProtocolNegotiationCompleted(Attributes attrs) {
    handleProtocolNegotiationCompleted(attrs, /*securityInfo=*/ null);
  }

  /**
   * Triggered on protocol negotiation alluxio.shaded.client.com.letion.
   *
   * <p>It must me called after negotiation is alluxio.shaded.client.com.leted but before given handler is added to the
   * channel.
   *
   * @param attrs arbitrary attributes passed after protocol negotiation (eg. SSLSession).
   * @param securityInfo informs channelz about the security protocol.
   */
  public void handleProtocolNegotiationCompleted(
      Attributes attrs, InternalChannelz.Security securityInfo) {
  }

  /**
   * Calling this method indicates that the channel will no longer be used.  This method is roughly
   * the same as calling {@link #close} on the channel, but leaving the channel alive.  This is
   * useful if the channel will soon be deregistered from the executor and used in a non-Netty
   * context.
   */
  @SuppressWarnings("FutureReturnValueIgnored")
  public void notifyUnused() {
    channelUnused.setSuccess(null);
  }

  /** Get the attributes of the EquivalentAddressGroup used to create this transport. */
  public Attributes getEagAttributes() {
    return Attributes.EMPTY;
  }

  /**
   * Returns the authority of the server. Only available on the client-side.
   *
   * @throws UnsupportedOperationException if on server-side
   */
  public String getAuthority() {
    throw new UnsupportedOperationException();
  }
}
