/*
 * Copyright 2015 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.io.grpc.Context;

/**
 * Utility base implementation of {@link Runnable} that performs the same function as
 * {@link Context#wrap(Runnable)} without requiring the construction of an additional object.
 */
abstract class ContextRunnable implements Runnable {

  private final Context context;

  public ContextRunnable(Context context) {
    this.context = context;
  }

  @Override
  public final void run() {
    Context previous = context.attach();
    try {
      runInContext();
    } finally {
      context.detach(previous);
    }
  }

  public abstract void runInContext();
}
