/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.Context;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.internal.CallTracer;
import alluxio.shaded.client.io.grpc.internal.ClientCallImpl;
import alluxio.shaded.client.io.grpc.internal.ClientStream;
import alluxio.shaded.client.io.grpc.internal.ClientStreamListener;
import alluxio.shaded.client.io.grpc.internal.ClientTransport;
import alluxio.shaded.client.io.grpc.internal.FailingClientTransport;
import alluxio.shaded.client.io.grpc.internal.GrpcUtil;
import alluxio.shaded.client.io.grpc.internal.InternalSubchannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class SubchannelChannel
extends Channel {
    @VisibleForTesting
    static final Status NOT_READY_ERROR = Status.UNAVAILABLE.withDescription("Subchannel is NOT READY");
    @VisibleForTesting
    static final Status WAIT_FOR_READY_ERROR = Status.UNAVAILABLE.withDescription("wait-for-ready RPC is not supported on Subchannel.asChannel()");
    private static final FailingClientTransport notReadyTransport = new FailingClientTransport(NOT_READY_ERROR, ClientStreamListener.RpcProgress.REFUSED);
    private final InternalSubchannel subchannel;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CallTracer callsTracer;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            ClientTransport transport = SubchannelChannel.this.subchannel.getTransport();
            if (transport == null) {
                return notReadyTransport;
            }
            return transport;
        }

        @Override
        public <ReqT> ClientStream newRetriableStream(MethodDescriptor<ReqT, ?> method, CallOptions callOptions, Metadata headers, Context context) {
            throw new UnsupportedOperationException("OobChannel should not create retriable streams");
        }
    };

    SubchannelChannel(InternalSubchannel subchannel, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, CallTracer callsTracer) {
        this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        this.executor = Preconditions.checkNotNull(executor, "executor");
        this.deadlineCancellationExecutor = Preconditions.checkNotNull(deadlineCancellationExecutor, "deadlineCancellationExecutor");
        this.callsTracer = Preconditions.checkNotNull(callsTracer, "callsTracer");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Executor effectiveExecutor;
        Executor executor = effectiveExecutor = callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor();
        if (callOptions.isWaitForReady()) {
            return new ClientCall<RequestT, ResponseT>(){

                @Override
                public void start(final ClientCall.Listener<ResponseT> listener, Metadata headers) {
                    effectiveExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onClose(WAIT_FOR_READY_ERROR, new Metadata());
                        }
                    });
                }

                @Override
                public void request(int numMessages) {
                }

                @Override
                public void cancel(String message, Throwable cause) {
                }

                @Override
                public void halfClose() {
                }

                @Override
                public void sendMessage(RequestT message) {
                }
            };
        }
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, effectiveExecutor, callOptions.withOption(GrpcUtil.CALL_OPTIONS_RPC_OWNED_BY_BALANCER, Boolean.TRUE), this.transportProvider, this.deadlineCancellationExecutor, this.callsTracer, false);
    }

    @Override
    public String authority() {
        return this.subchannel.getAuthority();
    }
}

