/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.cache.Cache;
import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.List;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class MetadataCache {
    private final Cache<String, CachedItem> mCache;

    public MetadataCache(int maxSize, long expirationTimeMs) {
        this.mCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(expirationTimeMs, TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public URIStatus get(AlluxioURI path) {
        CachedItem item = this.mCache.getIfPresent(path.getPath());
        if (item != null && item.getStatus() != null) {
            return item.getStatus();
        }
        return null;
    }

    public void put(AlluxioURI path, URIStatus status) {
        this.mCache.put(path.getPath(), new CachedItem(status));
    }

    public void put(String path, URIStatus status) {
        this.mCache.put(path, new CachedItem(status));
    }

    public void put(AlluxioURI dir, List<URIStatus> statuses) {
        this.mCache.put(dir.getPath(), new CachedItem(statuses));
        for (URIStatus status : statuses) {
            this.mCache.put(status.getPath(), new CachedItem(status));
        }
    }

    @Nullable
    public List<URIStatus> listStatus(AlluxioURI dir) {
        CachedItem item = this.mCache.getIfPresent(dir.getPath());
        if (item != null && item.getDirStatuses() != null) {
            return item.getDirStatuses();
        }
        return null;
    }

    @VisibleForTesting
    public long size() {
        return this.mCache.size();
    }

    private class CachedItem {
        private final URIStatus mStatus;
        private final List<URIStatus> mDirStatuses;

        public CachedItem(URIStatus status) {
            this.mStatus = status;
            this.mDirStatuses = null;
        }

        public CachedItem(List<URIStatus> statuses) {
            this.mStatus = null;
            this.mDirStatuses = statuses;
        }

        @Nullable
        public URIStatus getStatus() {
            return this.mStatus;
        }

        @Nullable
        public List<URIStatus> getDirStatuses() {
            return this.mDirStatuses;
        }
    }
}

