/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.AlluxioURI;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.MetricType;
import alluxio.grpc.MetricValue;
import alluxio.metrics.Metric;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.sink.Sink;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Gauge;
import alluxio.shaded.client.com.codahale.metrics.JvmAttributeGaugeSet;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import alluxio.shaded.client.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Joiner;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetricsSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSystem.class);
    private static final ConcurrentHashMap<String, String> CACHED_METRICS = new ConcurrentHashMap();
    private static int sResolveTimeout = (int)new InstancedConfiguration(ConfigurationUtils.defaults()).getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
    private static final ConcurrentHashMap<AlluxioURI, String> CACHED_ESCAPED_PATH = new ConcurrentHashMap();
    private static final Map<String, Long> LAST_REPORTED_METRICS = new HashMap<String, Long>();
    private static final Map<String, MetricType> SHOULD_REPORT_METRICS = new ConcurrentHashMap<String, MetricType>();
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("^(.*?[.].*?)[.].*");
    private static boolean sReported = false;
    private static Supplier<String> sSourceNameSupplier = CommonUtils.memoize(() -> MetricsSystem.constructSourceName());
    public static final String CLUSTER = "Cluster";
    public static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();
    @GuardedBy(value="MetricsSystem")
    private static List<Sink> sSinks;
    public static final String SINK_REGEX = "^sink\\.(.+)\\.(.+)";
    private static final TimeUnit MINIMAL_POLL_UNIT;
    private static final int MINIMAL_POLL_PERIOD = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSinks(String metricsConfFile) {
        Class<MetricsSystem> clazz = MetricsSystem.class;
        synchronized (MetricsSystem.class) {
            if (sSinks != null) {
                LOG.debug("Sinks have already been started.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (metricsConfFile.isEmpty()) {
                LOG.info("Metrics is not enabled.");
                return;
            }
            MetricsConfig config = new MetricsConfig(metricsConfFile);
            MetricsSystem.startSinksFromConfig(config);
            return;
        }
    }

    private static String constructSourceName() {
        PropertyKey sourceKey = null;
        switch (CommonUtils.PROCESS_TYPE.get()) {
            case MASTER: {
                sourceKey = PropertyKey.MASTER_HOSTNAME;
                break;
            }
            case WORKER: {
                sourceKey = PropertyKey.WORKER_HOSTNAME;
                break;
            }
            case CLIENT: {
                sourceKey = PropertyKey.USER_APP_ID;
                break;
            }
            case JOB_MASTER: {
                sourceKey = PropertyKey.JOB_MASTER_HOSTNAME;
                break;
            }
            case JOB_WORKER: {
                sourceKey = PropertyKey.JOB_WORKER_HOSTNAME;
                break;
            }
        }
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        return sourceKey != null && conf.isSet(sourceKey) ? conf.get(sourceKey) : NetworkAddressUtils.getLocalHostMetricName(sResolveTimeout);
    }

    public static synchronized void startSinksFromConfig(MetricsConfig config) {
        if (sSinks != null) {
            LOG.debug("Sinks have already been started.");
            return;
        }
        LOG.info("Starting sinks with config: {}.", (Object)config);
        sSinks = new ArrayList<Sink>();
        Map<String, Properties> sinkConfigs = MetricsConfig.subProperties(config.getProperties(), SINK_REGEX);
        for (Map.Entry<String, Properties> entry : sinkConfigs.entrySet()) {
            String classPath = entry.getValue().getProperty("class");
            if (classPath == null) continue;
            LOG.info("Starting sink {}.", (Object)classPath);
            try {
                Sink sink = (Sink)Class.forName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(entry.getValue(), METRIC_REGISTRY);
                sink.start();
                sSinks.add(sink);
            }
            catch (Exception e) {
                LOG.error("Sink class {} cannot be instantiated", (Object)classPath, (Object)e);
            }
        }
    }

    public static synchronized void stopSinks() {
        if (sSinks != null) {
            for (Sink sink : sSinks) {
                sink.stop();
            }
        }
        sSinks = null;
    }

    public static synchronized int getNumSinks() {
        int sz = 0;
        if (sSinks != null) {
            sz = sSinks.size();
        }
        return sz;
    }

    public static String getMetricName(String name) {
        if (name.startsWith(CLUSTER)) {
            return name;
        }
        switch (CommonUtils.PROCESS_TYPE.get()) {
            case CLIENT: {
                return MetricsSystem.getClientMetricName(name);
            }
            case MASTER: {
                return MetricsSystem.getMasterMetricName(name);
            }
            case PROXY: {
                return MetricsSystem.getProxyMetricName(name);
            }
            case WORKER: {
                return MetricsSystem.getWorkerMetricName(name);
            }
            case JOB_MASTER: {
                return MetricsSystem.getJobMasterMetricName(name);
            }
            case JOB_WORKER: {
                return MetricsSystem.getJobWorkerMetricName(name);
            }
        }
        throw new IllegalStateException("Unknown process type");
    }

    public static String getMasterMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        if (name.startsWith(InstanceType.MASTER.toString())) {
            return CACHED_METRICS.computeIfAbsent(name, n -> name);
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> InstanceType.MASTER.toString() + "." + name);
    }

    private static String getWorkerMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> MetricsSystem.getMetricNameWithUniqueId(InstanceType.WORKER, name));
    }

    private static String getClientMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        if (name.startsWith(InstanceType.MASTER.toString()) || name.startsWith(InstanceType.CLUSTER.toString())) {
            return CACHED_METRICS.computeIfAbsent(name, n -> name);
        }
        if (name.startsWith(InstanceType.WORKER.toString())) {
            return MetricsSystem.getWorkerMetricName(name);
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> MetricsSystem.getMetricNameWithUniqueId(InstanceType.CLIENT, name));
    }

    private static String getProxyMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(InstanceType.PROXY, name);
    }

    private static String getJobMasterMetricName(String name) {
        if (name.startsWith(InstanceType.JOB_MASTER.toString())) {
            return name;
        }
        return Joiner.on(".").join((Object)InstanceType.JOB_MASTER, name, new Object[0]);
    }

    public static String getJobWorkerMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(InstanceType.JOB_WORKER, name);
    }

    private static String getMetricNameWithUniqueId(InstanceType instance, String name) {
        if (name.startsWith(instance.toString())) {
            return Joiner.on(".").join(name, sSourceNameSupplier.get(), new Object[0]);
        }
        return Joiner.on(".").join((Object)instance, name, sSourceNameSupplier.get());
    }

    public static void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) throws IllegalArgumentException {
        int period = (int)MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        Preconditions.checkArgument(period >= 1, "Polling period %d %d is below the minimal polling period", pollPeriod, (Object)pollUnit);
    }

    public static String stripInstanceAndHost(String metricsName) {
        Object[] pieces = metricsName.split("\\.");
        int len = pieces.length;
        if (len <= 1) {
            return metricsName;
        }
        if (!pieces[0].equals(InstanceType.MASTER.toString()) && !pieces[0].equals(InstanceType.CLUSTER.toString()) && pieces.length > 2) {
            pieces[len - 1] = null;
        }
        pieces[0] = null;
        return Joiner.on(".").skipNulls().join(pieces);
    }

    public static String escape(AlluxioURI uri) {
        return CACHED_ESCAPED_PATH.computeIfAbsent(uri, u -> u.toString().replace("%", "%25").replace("/", "%2F").replace(".", "%2E"));
    }

    public static String unescape(String uri) {
        return uri.replace("%2F", "/").replace("%2E", ".").replace("%25", "%");
    }

    public static Counter counter(String name) {
        return METRIC_REGISTRY.counter(MetricsSystem.getMetricName(name));
    }

    public static Counter counterWithTags(String name, boolean shouldReport, String ... tags) {
        String fullName = MetricsSystem.getMetricName(Metric.getMetricNameWithTags(name, tags));
        if (shouldReport) {
            SHOULD_REPORT_METRICS.putIfAbsent(fullName, MetricType.COUNTER);
        }
        return METRIC_REGISTRY.counter(fullName);
    }

    public static Meter meter(String name) {
        return METRIC_REGISTRY.meter(MetricsSystem.getMetricName(name));
    }

    public static Meter meterWithTags(String name, boolean shouldReport, String ... tags) {
        String fullName = MetricsSystem.getMetricName(Metric.getMetricNameWithTags(name, tags));
        if (shouldReport) {
            SHOULD_REPORT_METRICS.putIfAbsent(fullName, MetricType.METER);
        }
        return METRIC_REGISTRY.meter(fullName);
    }

    public static Timer timer(String name) {
        return METRIC_REGISTRY.timer(MetricsSystem.getMetricName(name));
    }

    public static synchronized <T> void registerGaugeIfAbsent(String name, Gauge<T> metric) {
        if (!METRIC_REGISTRY.getMetrics().containsKey(name)) {
            METRIC_REGISTRY.register(name, metric);
        }
    }

    private static synchronized List<alluxio.grpc.Metric> reportMetrics(InstanceType instanceType) {
        if (!sReported) {
            MetricsSystem.initShouldReportMetrics(instanceType);
            sReported = true;
        }
        ArrayList<alluxio.grpc.Metric> rpcMetrics = new ArrayList<alluxio.grpc.Metric>(20);
        Map<String, alluxio.shaded.client.com.codahale.metrics.Metric> metrics = METRIC_REGISTRY.getMetrics();
        for (Map.Entry<String, MetricType> entry : SHOULD_REPORT_METRICS.entrySet()) {
            alluxio.shaded.client.com.codahale.metrics.Metric metric = metrics.get(entry.getKey());
            if (metric == null) continue;
            if (metric instanceof Counter) {
                double diff;
                Counter counter = (Counter)metric;
                long value = counter.getCount();
                Long prev = LAST_REPORTED_METRICS.replace(entry.getKey(), value);
                if (prev == null) {
                    LAST_REPORTED_METRICS.put(entry.getKey(), value);
                }
                if ((diff = prev != null ? (double)(value - prev) : (double)value) == 0.0) continue;
                rpcMetrics.add(Metric.from(entry.getKey(), diff, MetricType.COUNTER).toProto());
                continue;
            }
            if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                if (!(gauge.getValue() instanceof Number)) {
                    LOG.debug("The value of metric {} of type {} is not sent to metrics master, only metrics value of number can be collected", (Object)entry.getKey(), (Object)gauge.getValue().getClass().getSimpleName());
                    continue;
                }
                rpcMetrics.add(Metric.from(entry.getKey(), ((Number)gauge.getValue()).longValue(), MetricType.GAUGE).toProto());
                continue;
            }
            if (metric instanceof Meter) {
                Meter meter = (Meter)metric;
                rpcMetrics.add(Metric.from(entry.getKey(), meter.getOneMinuteRate(), MetricType.METER).toProto());
                continue;
            }
            if (metric instanceof Timer) {
                Timer timer = (Timer)metric;
                rpcMetrics.add(Metric.from(entry.getKey(), timer.getCount(), MetricType.TIMER).toProto());
                continue;
            }
            LOG.warn("Metric {} has invalid metric type {} which cannot be reported", (Object)entry.getKey(), (Object)entry.getValue());
        }
        return rpcMetrics;
    }

    public static List<alluxio.grpc.Metric> reportWorkerMetrics() {
        long start = System.currentTimeMillis();
        List<alluxio.grpc.Metric> metricsList = MetricsSystem.reportMetrics(InstanceType.WORKER);
        LOG.debug("Get the worker metrics list to report to leading master in {}ms", (Object)(System.currentTimeMillis() - start));
        return metricsList;
    }

    public static List<alluxio.grpc.Metric> reportClientMetrics() {
        long start = System.currentTimeMillis();
        List<alluxio.grpc.Metric> metricsList = MetricsSystem.reportMetrics(InstanceType.CLIENT);
        LOG.debug("Get the client metrics list to report to leading master in {}ms", (Object)(System.currentTimeMillis() - start));
        return metricsList;
    }

    public static Map<String, Set<Metric>> getMasterMetrics(Set<String> metricNames) {
        HashMap<String, Set<Metric>> res = new HashMap<String, Set<Metric>>();
        for (Map.Entry<String, alluxio.shaded.client.com.codahale.metrics.Metric> entry : METRIC_REGISTRY.getMetrics().entrySet()) {
            String name;
            Matcher matcher = METRIC_NAME_PATTERN.matcher(entry.getKey());
            if (!matcher.matches() || !metricNames.contains(name = matcher.group(1))) continue;
            res.computeIfAbsent(name, m3 -> new HashSet()).add(MetricsSystem.getAlluxioMetricFromCodahaleMetric(entry.getKey(), entry.getValue()));
        }
        return res;
    }

    @Nullable
    public static Metric getMetricValue(String fullName) {
        Map<String, alluxio.shaded.client.com.codahale.metrics.Metric> metricMap = METRIC_REGISTRY.getMetrics();
        alluxio.shaded.client.com.codahale.metrics.Metric metric = metricMap.get(fullName);
        if (metric == null) {
            return null;
        }
        return MetricsSystem.getAlluxioMetricFromCodahaleMetric(fullName, metric);
    }

    @Nullable
    private static Metric getAlluxioMetricFromCodahaleMetric(String name, alluxio.shaded.client.com.codahale.metrics.Metric metric) {
        if (metric instanceof Gauge) {
            Gauge gauge = (Gauge)metric;
            return Metric.from(name, ((Number)gauge.getValue()).longValue(), MetricType.GAUGE);
        }
        if (metric instanceof Counter) {
            Counter counter = (Counter)metric;
            return Metric.from(name, counter.getCount(), MetricType.COUNTER);
        }
        if (metric instanceof Meter) {
            Meter meter = (Meter)metric;
            return Metric.from(name, meter.getOneMinuteRate(), MetricType.METER);
        }
        if (metric instanceof Timer) {
            Timer timer = (Timer)metric;
            return Metric.from(name, timer.getCount(), MetricType.TIMER);
        }
        LOG.warn("Metric {} has invalid metric type {}", (Object)name, (Object)metric.getClass().getName());
        return null;
    }

    public static Map<String, MetricValue> allMetrics() {
        HashMap<String, MetricValue> metricsMap = new HashMap<String, MetricValue>();
        for (Map.Entry<String, alluxio.shaded.client.com.codahale.metrics.Metric> entry : METRIC_REGISTRY.getMetrics().entrySet()) {
            MetricValue.Builder valueBuilder = MetricValue.newBuilder();
            alluxio.shaded.client.com.codahale.metrics.Metric metric = entry.getValue();
            if (metric instanceof Gauge) {
                Object value = ((Gauge)metric).getValue();
                if (value instanceof Number) {
                    valueBuilder.setDoubleValue(((Number)value).doubleValue());
                } else {
                    valueBuilder.setStringValue(value.toString());
                }
                valueBuilder.setMetricType(MetricType.GAUGE);
            } else if (metric instanceof Counter) {
                valueBuilder.setMetricType(MetricType.COUNTER).setDoubleValue(((Counter)metric).getCount());
            } else if (metric instanceof Meter) {
                valueBuilder.setMetricType(MetricType.METER).setDoubleValue(((Meter)metric).getOneMinuteRate());
            } else if (metric instanceof Timer) {
                valueBuilder.setMetricType(MetricType.TIMER).setDoubleValue(((Timer)metric).getCount());
            } else {
                LOG.warn("Metric {} has invalid metric type {}", (Object)entry.getKey(), (Object)metric.getClass().getName());
                continue;
            }
            metricsMap.put(entry.getKey(), valueBuilder.build());
        }
        return metricsMap;
    }

    @VisibleForTesting
    public static void initShouldReportMetrics(InstanceType instanceType) {
        Set<MetricKey> metricKeys = MetricKey.allShouldReportMetricKeys(instanceType);
        for (MetricKey metricKey : metricKeys) {
            SHOULD_REPORT_METRICS.putIfAbsent(MetricsSystem.getMetricNameWithUniqueId(instanceType, metricKey.getName()), metricKey.getMetricType());
        }
    }

    public static synchronized void resetAllMetrics() {
        long startTime = System.currentTimeMillis();
        for (Counter counter : METRIC_REGISTRY.getCounters().values()) {
            counter.dec(counter.getCount());
        }
        for (String meterName : METRIC_REGISTRY.getMeters().keySet()) {
            METRIC_REGISTRY.remove(meterName);
            METRIC_REGISTRY.meter(meterName);
        }
        for (String timerName : METRIC_REGISTRY.getTimers().keySet()) {
            METRIC_REGISTRY.remove(timerName);
            METRIC_REGISTRY.timer(timerName);
        }
        LAST_REPORTED_METRICS.clear();
        LOG.info("Reset all metrics in the metrics system in {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    @VisibleForTesting
    public static void clearAllMetrics() {
        for (String name : METRIC_REGISTRY.getNames()) {
            METRIC_REGISTRY.remove(name);
        }
    }

    @VisibleForTesting
    public static void resetCountersAndGauges() {
        for (Map.Entry<String, Counter> entry : METRIC_REGISTRY.getCounters().entrySet()) {
            entry.getValue().dec(entry.getValue().getCount());
        }
        for (String gauge : METRIC_REGISTRY.getGauges().keySet()) {
            METRIC_REGISTRY.remove(gauge);
        }
    }

    private MetricsSystem() {
    }

    static {
        METRIC_REGISTRY.registerAll(new JvmAttributeGaugeSet());
        METRIC_REGISTRY.registerAll(new GarbageCollectorMetricSet());
        METRIC_REGISTRY.registerAll(new MemoryUsageGaugeSet());
        MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
    }

    public static enum InstanceType {
        JOB_MASTER("JobMaster"),
        JOB_WORKER("JobWorker"),
        MASTER("Master"),
        WORKER("Worker"),
        CLUSTER("Cluster"),
        CLIENT("Client"),
        PROXY("Proxy");

        private String mValue;

        private InstanceType(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }

        public static InstanceType fromString(String text) {
            for (InstanceType type : InstanceType.values()) {
                if (!type.toString().equalsIgnoreCase(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("No constant with text " + text + " found");
        }
    }
}

