/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.annotations.GwtCompatible;
import java.alluxio.shaded.client.io.Serializable;
import alluxio.shaded.client.org.checkerframework.checker.nullness.qual.MonotonicNonNull;

/** An ordering that uses the natural order of the values. */
@GwtCompatible(serializable = true)
@SuppressWarnings("unchecked") // TODO(kevinb): the right way to explain this??
final class NaturalOrdering extends Ordering<Comparable> implements Serializable {
  static final NaturalOrdering INSTANCE = new NaturalOrdering();

  private transient @MonotonicNonNull Ordering<Comparable> nullsFirst;
  private transient @MonotonicNonNull Ordering<Comparable> nullsLast;

  @Override
  public int alluxio.shaded.client.com.are(Comparable left, Comparable right) {
    checkNotNull(left); // for GWT
    checkNotNull(right);
    return left.alluxio.shaded.client.com.areTo(right);
  }

  @Override
  public <S extends Comparable> Ordering<S> nullsFirst() {
    Ordering<Comparable> result = nullsFirst;
    if (result == null) {
      result = nullsFirst = super.nullsFirst();
    }
    return (Ordering<S>) result;
  }

  @Override
  public <S extends Comparable> Ordering<S> nullsLast() {
    Ordering<Comparable> result = nullsLast;
    if (result == null) {
      result = nullsLast = super.nullsLast();
    }
    return (Ordering<S>) result;
  }

  @Override
  public <S extends Comparable> Ordering<S> reverse() {
    return (Ordering<S>) ReverseNaturalOrdering.INSTANCE;
  }

  // preserving singleton-ness gives equals()/hashCode() for free
  private Object readResolve() {
    return INSTANCE;
  }

  @Override
  public String toString() {
    return "Ordering.natural()";
  }

  private NaturalOrdering() {}

  private static final long serialVersionUID = 0;
}
