/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    public static String formatStackTrace(Thread thread) {
        Throwable t = new Throwable(String.format("Stack trace for thread %s (State: %s):", new Object[]{thread.getName(), thread.getState()}));
        t.setStackTrace(thread.getStackTrace());
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void logAllThreads() {
        StringBuilder sb = new StringBuilder("Dumping all threads:\n");
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            sb.append(ThreadUtils.formatStackTrace(t));
        }
        LOG.info(sb.toString());
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeoutMs) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeoutMs / 2L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeoutMs / 2L, TimeUnit.MILLISECONDS)) {
                    LOG.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            pool.shutdownNow();
        }
    }

    private ThreadUtils() {
    }
}

