/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.base.Throwables;
import alluxio.shaded.client.com.google.common.collect.Iterables;
import java.io.InterruptedIOException;

public final class ExceptionUtils {
    public static boolean containsInterruptedException(Throwable t) {
        return !Iterables.isEmpty(Iterables.filter(Throwables.getCausalChain(t), x -> ExceptionUtils.isInterrupted(x)));
    }

    public static boolean isInterrupted(Throwable t) {
        return t instanceof InterruptedException || t instanceof InterruptedIOException;
    }

    private ExceptionUtils() {
    }
}

