/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.tags;

import alluxio.shaded.client.io.opencensus.internal.StringUtils;
import alluxio.shaded.client.io.opencensus.internal.Utils;
import alluxio.shaded.client.io.opencensus.tags.AutoValue_TagKey;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Utils.checkArgument(TagKey.isValid(name), "Invalid TagKey name: %s", name);
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

