/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.metrics;

import alluxio.shaded.client.io.opencensus.internal.Utils;
import alluxio.shaded.client.io.opencensus.metrics.DerivedDoubleGauge;
import alluxio.shaded.client.io.opencensus.metrics.DerivedLongGauge;
import alluxio.shaded.client.io.opencensus.metrics.DoubleGauge;
import alluxio.shaded.client.io.opencensus.metrics.LabelKey;
import alluxio.shaded.client.io.opencensus.metrics.LongGauge;
import java.util.List;

public abstract class MetricRegistry {
    public abstract LongGauge addLongGauge(String var1, String var2, String var3, List<LabelKey> var4);

    public abstract DoubleGauge addDoubleGauge(String var1, String var2, String var3, List<LabelKey> var4);

    public abstract DerivedLongGauge addDerivedLongGauge(String var1, String var2, String var3, List<LabelKey> var4);

    public abstract DerivedDoubleGauge addDerivedDoubleGauge(String var1, String var2, String var3, List<LabelKey> var4);

    static MetricRegistry newNoopMetricRegistry() {
        return new NoopMetricRegistry();
    }

    private static final class NoopMetricRegistry
    extends MetricRegistry {
        private NoopMetricRegistry() {
        }

        @Override
        public LongGauge addLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            return LongGauge.newNoopLongGauge(Utils.checkNotNull(name, "name"), Utils.checkNotNull(description, "description"), Utils.checkNotNull(unit, "unit"), labelKeys);
        }

        @Override
        public DoubleGauge addDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            return DoubleGauge.newNoopDoubleGauge(Utils.checkNotNull(name, "name"), Utils.checkNotNull(description, "description"), Utils.checkNotNull(unit, "unit"), labelKeys);
        }

        @Override
        public DerivedLongGauge addDerivedLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            return DerivedLongGauge.newNoopDerivedLongGauge(Utils.checkNotNull(name, "name"), Utils.checkNotNull(description, "description"), Utils.checkNotNull(unit, "unit"), labelKeys);
        }

        @Override
        public DerivedDoubleGauge addDerivedDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            return DerivedDoubleGauge.newNoopDerivedDoubleGauge(Utils.checkNotNull(name, "name"), Utils.checkNotNull(description, "description"), Utils.checkNotNull(unit, "unit"), labelKeys);
        }
    }
}

