/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.TimeBoundedRetry;
import alluxio.time.TimeContext;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public final class ExponentialTimeBoundedRetry
extends TimeBoundedRetry {
    private final Duration mMaxSleep;
    private Duration mNextSleep;

    private ExponentialTimeBoundedRetry(TimeContext timeCtx, Duration maxDuration, Duration initialSleep, Duration maxSleep) {
        super(timeCtx, maxDuration);
        this.mMaxSleep = maxSleep;
        this.mNextSleep = initialSleep;
    }

    @Override
    protected Duration computeNextWaitTime() {
        Duration next = this.mNextSleep;
        this.mNextSleep = this.mNextSleep.multipliedBy(2L);
        if (this.mNextSleep.compareTo(this.mMaxSleep) > 0) {
            this.mNextSleep = this.mMaxSleep;
        }
        long jitter = Math.round(ThreadLocalRandom.current().nextDouble(0.1) * (double)next.toMillis());
        return next.plusMillis(jitter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TimeContext mTimeCtx = TimeContext.SYSTEM;
        private Duration mMaxDuration;
        private Duration mInitialSleep;
        private Duration mMaxSleep;

        public Builder withTimeCtx(TimeContext timeCtx) {
            this.mTimeCtx = timeCtx;
            return this;
        }

        public Builder withMaxDuration(Duration maxDuration) {
            this.mMaxDuration = maxDuration;
            return this;
        }

        public Builder withInitialSleep(Duration initialSleep) {
            this.mInitialSleep = initialSleep;
            return this;
        }

        public Builder withMaxSleep(Duration maxSleep) {
            this.mMaxSleep = maxSleep;
            return this;
        }

        public ExponentialTimeBoundedRetry build() {
            return new ExponentialTimeBoundedRetry(this.mTimeCtx, this.mMaxDuration, this.mInitialSleep, this.mMaxSleep);
        }
    }
}

