/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.aggregator;

import alluxio.metrics.Metric;
import alluxio.metrics.MetricsFilter;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.SingleValueAggregator;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SumInstancesAggregator
implements SingleValueAggregator {
    private final MetricsSystem.InstanceType mInstanceType;
    private final String mAggregationName;
    private final MetricsFilter mFilter;

    public SumInstancesAggregator(String aggregationName, MetricsSystem.InstanceType instanceType, String metricName) {
        Preconditions.checkNotNull(instanceType, "instance type");
        Preconditions.checkNotNull(metricName, "metricName");
        Preconditions.checkNotNull(aggregationName, "aggregationName");
        this.mInstanceType = instanceType;
        this.mAggregationName = aggregationName;
        this.mFilter = new MetricsFilter(this.mInstanceType, metricName);
    }

    public MetricsSystem.InstanceType getInstanceType() {
        return this.mInstanceType;
    }

    @Override
    public String getName() {
        return this.mAggregationName;
    }

    @Override
    public List<MetricsFilter> getFilters() {
        return Lists.newArrayList(this.mFilter);
    }

    @Override
    public long getValue(Map<MetricsFilter, Set<Metric>> map) {
        long value = 0L;
        for (Metric metric : map.get(this.mFilter)) {
            value = (long)((double)value + metric.getValue());
        }
        return value;
    }
}

