/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.resource.DynamicResourcePool;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.ThreadFactoryUtils;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockWorkerClientPool
extends DynamicResourcePool<BlockWorkerClient> {
    private static final Logger LOG = LoggerFactory.getLogger(BlockWorkerClientPool.class);
    private final Subject mSubject;
    private final GrpcServerAddress mAddress;
    private static final int WORKER_CLIENT_POOL_GC_THREADPOOL_SIZE = 10;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(10, ThreadFactoryUtils.build("BlockWorkerClientPoolGcThreads-%d", true));
    private final AlluxioConfiguration mConf;
    private final EventLoopGroup mWorkerGroup;

    public BlockWorkerClientPool(Subject subject, GrpcServerAddress address, int maxCapacity, AlluxioConfiguration alluxioConf, EventLoopGroup workerGroup) {
        super(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        this.mSubject = subject;
        this.mAddress = address;
        this.mConf = alluxioConf;
        this.mWorkerGroup = workerGroup;
    }

    @Override
    protected void closeResource(BlockWorkerClient client) throws IOException {
        LOG.info("Block worker client for {} closed.", (Object)this.mAddress);
        client.close();
    }

    @Override
    protected BlockWorkerClient createNewResource() throws IOException {
        return BlockWorkerClient.Factory.create(this.mSubject, this.mAddress, this.mConf, this.mWorkerGroup);
    }

    @Override
    protected boolean isHealthy(BlockWorkerClient client) {
        return client.isHealthy();
    }

    @Override
    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<BlockWorkerClient> clientResourceInternal) {
        return System.currentTimeMillis() - clientResourceInternal.getLastAccessTimeMs() > this.mConf.getMs(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS);
    }
}

