/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.task;

import alluxio.collections.Pair;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.RunTaskCommand;
import alluxio.job.ErrorUtils;
import alluxio.job.RunTaskContext;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.logging.SamplingLogger;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.task.PausableThreadPoolExecutor;
import alluxio.worker.job.task.TaskExecutor;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TaskExecutorManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorManager.class);
    private static final SamplingLogger SAMPLING_LOGGER = new SamplingLogger(LOG, 30000L);
    private static final int MAX_TASK_EXECUTOR_POOL_SIZE = 10000;
    private final PausableThreadPoolExecutor mTaskExecutionService;
    private final Map<Pair<Long, Long>, Future<?>> mTaskFutures = Maps.newHashMap();
    private final Map<Pair<Long, Long>, TaskInfo> mUnfinishedTasks = Maps.newHashMap();
    private final Map<Pair<Long, Long>, TaskInfo> mTaskUpdates = Maps.newHashMap();
    private final WorkerNetAddress mAddress;
    private int mDefaultTaskExecutorPoolSize;
    private boolean mThrottled;

    public TaskExecutorManager(int taskExecutorPoolSize, WorkerNetAddress address) {
        this.mTaskExecutionService = new PausableThreadPoolExecutor(taskExecutorPoolSize, 10000, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactoryUtils.build((String)"task-execution-service-%d", (boolean)true));
        this.mDefaultTaskExecutorPoolSize = taskExecutorPoolSize;
        this.mThrottled = false;
        this.mAddress = address;
    }

    public int getNumActiveTasks() {
        return this.mTaskExecutionService.getNumActiveTasks();
    }

    public int getTaskExecutorPoolSize() {
        return this.mTaskExecutionService.getCorePoolSize();
    }

    private synchronized void setTaskExecutorPoolSize(int taskExecutorPoolSize) {
        Preconditions.checkArgument((taskExecutorPoolSize >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((taskExecutorPoolSize <= 10000 ? 1 : 0) != 0);
        if (taskExecutorPoolSize == 0) {
            this.mTaskExecutionService.pause();
        } else {
            this.mTaskExecutionService.resume();
        }
        this.mTaskExecutionService.setCorePoolSize(taskExecutorPoolSize);
    }

    public synchronized void setDefaultTaskExecutorPoolSize(int defaultTaskExecutorPoolSize) {
        this.mDefaultTaskExecutorPoolSize = defaultTaskExecutorPoolSize;
        if (!this.mThrottled) {
            this.setTaskExecutorPoolSize(this.mDefaultTaskExecutorPoolSize);
        }
    }

    public synchronized void throttle() {
        this.mThrottled = true;
        this.setTaskExecutorPoolSize(0);
    }

    public synchronized void unthrottle() {
        this.mThrottled = false;
        this.setTaskExecutorPoolSize(this.mDefaultTaskExecutorPoolSize);
    }

    public int unfinishedTasks() {
        return this.mUnfinishedTasks.size();
    }

    public synchronized void notifyTaskRunning(long jobId, long taskId) {
        Pair id = new Pair((Object)jobId, (Object)taskId);
        TaskInfo taskInfo = this.mUnfinishedTasks.get(id);
        taskInfo.setStatus(Status.RUNNING);
        LOG.info("Task {} for job {} started", (Object)taskId, (Object)jobId);
    }

    public synchronized void notifyTaskCompletion(long jobId, long taskId, Serializable result) {
        Pair id = new Pair((Object)jobId, (Object)taskId);
        TaskInfo taskInfo = this.mUnfinishedTasks.get(id);
        taskInfo.setStatus(Status.COMPLETED);
        taskInfo.setResult(result);
        this.finishTask((Pair<Long, Long>)id);
        LOG.info("Task {} for job {} completed.", (Object)taskId, (Object)jobId);
    }

    public synchronized void notifyTaskFailure(long jobId, long taskId, Throwable t) {
        Pair id = new Pair((Object)jobId, (Object)taskId);
        TaskInfo taskInfo = this.mUnfinishedTasks.get(id);
        taskInfo.setStatus(Status.FAILED);
        String errorMessage = Configuration.getBoolean((PropertyKey)PropertyKey.DEBUG) ? Throwables.getStackTraceAsString((Throwable)t) : t.getMessage();
        taskInfo.setErrorType(ErrorUtils.getErrorType((Throwable)t));
        if (errorMessage != null) {
            taskInfo.setErrorMessage(errorMessage);
        }
        this.finishTask((Pair<Long, Long>)id);
        LOG.info("Task {} for job {} failed: {}", new Object[]{taskId, jobId, errorMessage});
        SAMPLING_LOGGER.info("Stack trace for taskId: {} jobId: {} : {}", new Object[]{taskId, jobId, Throwables.getStackTraceAsString((Throwable)t)});
    }

    public synchronized void executeTask(long jobId, long taskId, RunTaskCommand runTaskCommand, RunTaskContext context) {
        Future<?> future = this.mTaskExecutionService.submit(new TaskExecutor(jobId, taskId, runTaskCommand, context, this));
        Pair id = new Pair((Object)jobId, (Object)taskId);
        this.mTaskFutures.put((Pair<Long, Long>)id, future);
        TaskInfo taskInfo = new TaskInfo(jobId, taskId, Status.CREATED, this.mAddress, null);
        this.mUnfinishedTasks.put((Pair<Long, Long>)id, taskInfo);
        this.mTaskUpdates.put((Pair<Long, Long>)id, taskInfo);
        LOG.info("Task {} for job {} received", (Object)taskId, (Object)jobId);
    }

    public synchronized void cancelTask(long jobId, long taskId) {
        Pair id = new Pair((Object)jobId, (Object)taskId);
        TaskInfo taskInfo = this.mUnfinishedTasks.get(id);
        if (!this.mTaskFutures.containsKey(id) || taskInfo.getStatus().equals((Object)Status.CANCELED)) {
            return;
        }
        Future<?> future = this.mTaskFutures.get(id);
        if (!future.cancel(true)) {
            taskInfo.setStatus(Status.FAILED);
            taskInfo.setErrorType("FailedCancel");
            taskInfo.setErrorMessage("Failed to cancel the task");
            LOG.info("Failed to cancel task {} for job {}", (Object)taskId, (Object)jobId);
        } else {
            taskInfo.setStatus(Status.CANCELED);
            LOG.info("Task {} for job {} canceled", (Object)taskId, (Object)jobId);
        }
        this.finishTask((Pair<Long, Long>)id);
    }

    public synchronized List<TaskInfo> getAndClearTaskUpdates() {
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.mTaskUpdates.values());
            return immutableList;
        }
        finally {
            this.mTaskUpdates.clear();
        }
    }

    public synchronized void restoreTaskUpdates(List<TaskInfo> tasks) {
        for (TaskInfo task : tasks) {
            Pair id = new Pair((Object)task.getParentId(), (Object)task.getId());
            if (this.mTaskUpdates.containsKey(id)) continue;
            this.mTaskUpdates.put((Pair<Long, Long>)id, task);
        }
    }

    private void finishTask(Pair<Long, Long> id) {
        TaskInfo taskInfo = this.mUnfinishedTasks.get(id);
        this.mTaskFutures.remove(id);
        this.mUnfinishedTasks.remove(id);
        this.mTaskUpdates.put(id, taskInfo);
    }
}

