/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.util.io.PathUtils;
import alluxio.web.WebServer;
import alluxio.worker.JobWorkerProcess;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

@NotThreadSafe
public final class JobWorkerWebServer
extends WebServer {
    public static final String ALLUXIO_JOB_WORKER_SERVLET_RESOURCE_KEY = "Alluxio Job Worker";

    public JobWorkerWebServer(String serviceName, InetSocketAddress address, final JobWorkerProcess jobWorker) {
        super(serviceName, address);
        ResourceConfig config = new ResourceConfig().packages(new String[]{"alluxio.worker"});
        ServletContainer servlet = new ServletContainer(config){
            private static final long serialVersionUID = 7756010860672831556L;

            public void init() throws ServletException {
                super.init();
                this.getServletContext().setAttribute(JobWorkerWebServer.ALLUXIO_JOB_WORKER_SERVLET_RESOURCE_KEY, (Object)jobWorker);
            }
        };
        ServletHolder servletHolder = new ServletHolder("Alluxio Job Worker Web Service", (Servlet)servlet);
        this.mServletContextHandler.addServlet(servletHolder, PathUtils.concatPath((Object)"/api/v1", (Object)"*"));
    }
}

