/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.workflow;

import alluxio.collections.ConcurrentHashSet;
import alluxio.exception.JobDoesNotExistException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.job.ErrorUtils;
import alluxio.job.JobConfig;
import alluxio.job.plan.meta.PlanInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.WorkflowInfo;
import alluxio.job.workflow.WorkflowConfig;
import alluxio.job.workflow.WorkflowExecution;
import alluxio.job.workflow.WorkflowExecutionRegistry;
import alluxio.master.job.JobMaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowTracker {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowTracker.class);
    private final JobMaster mJobMaster;
    private final ConcurrentHashMap<Long, WorkflowExecution> mWorkflows;
    private final ConcurrentHashMap<Long, ConcurrentHashSet<Long>> mWaitingOn;
    private final ConcurrentHashMap<Long, ConcurrentHashSet<Long>> mChildren;
    private final ConcurrentHashMap<Long, Long> mParentWorkflow;

    public WorkflowTracker(JobMaster jobMaster) {
        this.mJobMaster = jobMaster;
        this.mWorkflows = new ConcurrentHashMap();
        this.mWaitingOn = new ConcurrentHashMap();
        this.mChildren = new ConcurrentHashMap();
        this.mParentWorkflow = new ConcurrentHashMap();
    }

    public synchronized void run(WorkflowConfig workflowConfig, long jobId) throws JobDoesNotExistException, ResourceExhaustedException {
        WorkflowExecution workflowExecution = WorkflowExecutionRegistry.INSTANCE.getExecution(workflowConfig);
        this.mWorkflows.put(jobId, workflowExecution);
        this.next(jobId);
    }

    public synchronized boolean cancel(long jobId) {
        ConcurrentHashSet<Long> children = this.mChildren.get(jobId);
        if (children == null) {
            return false;
        }
        for (Long child : children) {
            try {
                this.mJobMaster.cancel(child);
            }
            catch (JobDoesNotExistException e) {
                LOG.info("Tried to cancel jobId: {} but the job did not exist", (Object)child);
            }
        }
        return true;
    }

    public WorkflowInfo getStatus(long jobId, boolean verbose) {
        WorkflowExecution workflowExecution = this.mWorkflows.get(jobId);
        if (workflowExecution == null) {
            return null;
        }
        ArrayList children = Lists.newArrayList((Iterator)this.mChildren.get(jobId).iterator());
        Collections.sort(children);
        ArrayList jobInfos = Lists.newArrayList();
        if (verbose) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                long child = (Long)iterator.next();
                try {
                    jobInfos.add(this.mJobMaster.getStatus(child));
                }
                catch (JobDoesNotExistException e) {
                    LOG.info(String.format("No job info on child job id %s. Skipping", child));
                }
            }
        }
        return new WorkflowInfo(jobId, workflowExecution.getName(), workflowExecution.getStatus(), workflowExecution.getLastUpdated(), workflowExecution.getErrorType(), workflowExecution.getErrorMessage(), (List)jobInfos);
    }

    public Collection<WorkflowInfo> getAllInfo() {
        ArrayList res = Lists.newArrayList();
        for (Long workflowId : this.mWorkflows.keySet()) {
            res.add(this.getStatus(workflowId, false));
        }
        return res;
    }

    public Set<Long> findJobs(String name, List<Status> statusList) {
        HashSet<Long> jobs = new HashSet<Long>();
        for (Long workflowId : this.mWorkflows.entrySet().stream().filter(x -> statusList.isEmpty() || statusList.contains(((WorkflowExecution)x.getValue()).getStatus())).map(Map.Entry::getKey).collect(Collectors.toList())) {
            if (name != null && !name.isEmpty() && !this.mWorkflows.get(workflowId).getName().equals(name)) continue;
            jobs.add(workflowId);
        }
        return jobs;
    }

    public Collection<Long> list() {
        return Collections.unmodifiableCollection(this.mWorkflows.keySet());
    }

    public synchronized void cleanup(Collection<Long> removedPlanIds) {
        for (long removedPlanId : removedPlanIds) {
            this.clean(removedPlanId);
        }
    }

    private synchronized void clean(long jobId) {
        WorkflowExecution parentExecution;
        this.mWorkflows.remove(jobId);
        this.mWaitingOn.remove(jobId);
        this.mChildren.remove(jobId);
        Long parentId = this.mParentWorkflow.remove(jobId);
        if (parentId == null) {
            return;
        }
        ConcurrentHashSet<Long> siblings = this.mChildren.get(parentId);
        siblings.remove((Object)jobId);
        if (siblings.isEmpty() && (parentExecution = this.mWorkflows.get(parentId)) != null && parentExecution.getStatus().isFinished()) {
            this.clean(parentId);
        }
    }

    private synchronized void done(long jobId) {
        Long parentJobId = this.mParentWorkflow.get(jobId);
        if (parentJobId == null) {
            return;
        }
        ConcurrentHashSet<Long> siblings = this.mWaitingOn.get(parentJobId);
        siblings.remove((Object)jobId);
        if (siblings.isEmpty()) {
            this.next(parentJobId);
        }
    }

    private synchronized void stop(long jobId, Status status, String errorType, String errorMessage) {
        Long parentJobId = this.mParentWorkflow.get(jobId);
        if (parentJobId == null) {
            return;
        }
        WorkflowExecution workflowExecution = this.mWorkflows.get(parentJobId);
        workflowExecution.stop(status, errorType, errorMessage);
        this.stop(parentJobId, status, errorType, errorMessage);
    }

    private synchronized void next(long jobId) {
        WorkflowExecution workflowExecution = this.mWorkflows.get(jobId);
        this.mChildren.putIfAbsent(jobId, (ConcurrentHashSet<Long>)new ConcurrentHashSet());
        Set<JobConfig> childJobConfigs = workflowExecution.next();
        if (childJobConfigs.isEmpty()) {
            this.done(jobId);
            return;
        }
        ConcurrentHashSet childJobIds = new ConcurrentHashSet();
        for (int i = 0; i < childJobConfigs.size(); ++i) {
            childJobIds.add((Object)this.mJobMaster.getNewJobId());
        }
        this.mWaitingOn.put(jobId, (ConcurrentHashSet<Long>)childJobIds);
        this.mChildren.get(jobId).addAll((Collection)childJobIds);
        for (Long childJobId : childJobIds) {
            this.mParentWorkflow.put(childJobId, jobId);
        }
        Iterator childJobIdsIter = childJobIds.iterator();
        Iterator<JobConfig> childJobConfigsIter = childJobConfigs.iterator();
        while (childJobIdsIter.hasNext() && childJobConfigsIter.hasNext()) {
            Long childJobId = (Long)childJobIdsIter.next();
            JobConfig childJobConfig = childJobConfigsIter.next();
            try {
                this.mJobMaster.run(childJobConfig, childJobId);
            }
            catch (JobDoesNotExistException | ResourceExhaustedException e) {
                LOG.warn(e.getMessage());
                String errorType = ErrorUtils.getErrorType((Throwable)e);
                workflowExecution.stop(Status.FAILED, errorType, e.getMessage());
                this.stop(jobId, Status.FAILED, errorType, e.getMessage());
            }
        }
    }

    public void onPlanStatusChange(PlanInfo planInfo) {
        Status status = planInfo.getStatus();
        switch (status) {
            case COMPLETED: {
                this.done(planInfo.getId());
                break;
            }
            case CANCELED: 
            case FAILED: {
                this.stop(planInfo.getId(), status, planInfo.getErrorType(), planInfo.getErrorMessage());
                break;
            }
        }
    }
}

