/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.grpc.OperationType;
import alluxio.job.JobConfig;
import alluxio.job.cmd.persist.PersistCmdConfig;
import alluxio.job.wire.JobSource;
import alluxio.master.job.JobMaster;
import alluxio.master.job.common.CmdInfo;
import alluxio.master.job.metrics.DistributedCmdMetrics;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;

public class PersistRunner {
    static final long DEFAULT_FILE_COUNT = 1L;
    private final FileSystem mFileSystem;
    private final JobMaster mJobMaster;

    public PersistRunner(@Nullable FileSystemContext fsContext, JobMaster jobMaster) {
        if (fsContext == null) {
            fsContext = FileSystemContext.create();
        }
        this.mFileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
        this.mJobMaster = jobMaster;
    }

    public CmdInfo runPersistJob(PersistCmdConfig config, long jobControlId) {
        long submissionTime = System.currentTimeMillis();
        CmdInfo cmdInfo = new CmdInfo(jobControlId, OperationType.PERSIST, JobSource.SYSTEM, submissionTime, Lists.newArrayList((Object[])new String[]{config.getFilePath()}));
        CmdRunAttempt attempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        this.setJobConfigAndFileMetrics(config, attempt);
        cmdInfo.addCmdRunAttempt(attempt);
        attempt.run();
        return cmdInfo;
    }

    private void setJobConfigAndFileMetrics(PersistCmdConfig config, CmdRunAttempt attempt) {
        long fileSize = DistributedCmdMetrics.getFileSize(config.getFilePath(), this.mFileSystem, (RetryPolicy)new CountingRetry(3));
        attempt.setFileCount(1L);
        attempt.setFileSize(fileSize);
        attempt.setConfig((JobConfig)config.toPersistConfig());
    }
}

