/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.exception.JobDoesNotExistException;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.job.JobMaster;
import alluxio.retry.RetryPolicy;
import com.beust.jcommander.internal.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdRunAttempt {
    private static final Logger LOG = LoggerFactory.getLogger(CmdRunAttempt.class);
    private static final String DISTLOAD_PATH_PREFIX = "FilePath=";
    private static final String DISTCP_PATH_PREFIX = "source=";
    protected final RetryPolicy mRetryPolicy;
    protected final JobMaster mJobMaster;
    private Long mJobId;
    private long mCreationTime;
    private JobConfig mJobConfig;
    private long mFileCount;
    private long mFileSize;
    private final Set<String> mFailedFiles = Sets.newHashSet();
    private String mFilePathString;

    protected CmdRunAttempt(RetryPolicy retryPolicy, JobMaster jobMaster) {
        this.mRetryPolicy = retryPolicy;
        this.mJobMaster = jobMaster;
        this.mJobId = null;
    }

    public void setConfig(JobConfig config) {
        this.mJobConfig = config;
    }

    public void setFileCount(long fileCount) {
        this.mFileCount = fileCount;
    }

    public void setFileSize(long fileSize) {
        this.mFileSize = fileSize;
    }

    public void setFilePath(String filePath) {
        this.mFilePathString = filePath;
    }

    public JobConfig getJobConfig() {
        return this.mJobConfig;
    }

    public long getFileCount() {
        return this.mFileCount;
    }

    public long getFileSize() {
        return this.mFileSize;
    }

    public String getFilePath() {
        return this.mFilePathString;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public boolean run() {
        this.mCreationTime = System.currentTimeMillis();
        while (this.mRetryPolicy.attempt()) {
            try {
                this.mJobId = this.mJobMaster.run(this.getJobConfig());
            }
            catch (JobDoesNotExistException | IOException e) {
                int retryCount = this.mRetryPolicy.getAttemptCount();
                System.out.println(String.format("Retry %d Failed to start job with error: %s", retryCount, e.getMessage()));
                LOG.warn("Retry {} Failed to get status for job (jobId={}) {}", new Object[]{retryCount, this.mJobId, e});
                continue;
            }
            return true;
        }
        return false;
    }

    public Long getJobId() {
        return this.mJobId;
    }

    public Status checkJobStatus() {
        JobInfo jobInfo;
        if (this.mJobId == null) {
            return Status.FAILED;
        }
        try {
            jobInfo = this.mJobMaster.getStatus(this.mJobId);
        }
        catch (JobDoesNotExistException e) {
            LOG.warn("Failed to get status for job (jobId={})", (Object)this.mJobId, (Object)e);
            return Status.FAILED;
        }
        boolean finished = true;
        for (JobInfo child2 : jobInfo.getChildren()) {
            if (child2.getStatus().isFinished()) continue;
            finished = false;
            break;
        }
        if (finished) {
            if (jobInfo.getStatus().equals((Object)Status.FAILED)) {
                String prefix = this.getPrefix(jobInfo);
                Set failed = jobInfo.getChildren().stream().filter(child -> child.getStatus() == Status.FAILED).collect(Collectors.toSet());
                for (JobInfo task : failed) {
                    String filePath = StringUtils.substringBetween((String)task.getDescription(), (String)prefix, (String)",");
                    if (filePath == null) {
                        filePath = String.format("unknown filePath for task: %s", task.getId());
                    }
                    this.mFailedFiles.add(filePath);
                }
            }
            return jobInfo.getStatus();
        }
        return Status.RUNNING;
    }

    public void printFailed() {
        LOG.warn("Failed file paths are:  ");
        this.mFailedFiles.forEach(arg_0 -> ((Logger)LOG).warn(arg_0));
    }

    public Set<String> getFailedFiles() {
        return this.mFailedFiles;
    }

    private String getPrefix(JobInfo jobInfo) {
        if (jobInfo.getDescription().contains(DISTLOAD_PATH_PREFIX)) {
            return DISTLOAD_PATH_PREFIX;
        }
        if (jobInfo.getDescription().contains(DISTCP_PATH_PREFIX)) {
            return DISTCP_PATH_PREFIX;
        }
        return DISTLOAD_PATH_PREFIX;
    }
}

