/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.job.CmdConfig;
import alluxio.job.cmd.load.LoadCliConfig;
import alluxio.job.cmd.migrate.MigrateCliConfig;
import alluxio.job.cmd.persist.PersistCmdConfig;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.SimpleJobStatusBlock;
import alluxio.job.wire.Status;
import alluxio.master.job.JobMaster;
import alluxio.master.job.common.CmdInfo;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.master.job.tracker.DistLoadCliRunner;
import alluxio.master.job.tracker.MigrateCliRunner;
import alluxio.master.job.tracker.PersistRunner;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CmdJobTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CmdJobTracker.class);
    private final Map<Long, CmdInfo> mInfoMap = new ConcurrentHashMap<Long, CmdInfo>(0, 0.95f, Math.max(8, 2 * Runtime.getRuntime().availableProcessors()));
    private final DistLoadCliRunner mDistLoadCliRunner;
    private final MigrateCliRunner mMigrateCliRunner;
    private final PersistRunner mPersistRunner;
    protected FileSystemContext mFsContext;
    public static final String DELIMITER = ",";

    public CmdJobTracker(FileSystemContext fsContext, JobMaster jobMaster) {
        this.mFsContext = fsContext;
        this.mDistLoadCliRunner = new DistLoadCliRunner(this.mFsContext, jobMaster);
        this.mMigrateCliRunner = new MigrateCliRunner(this.mFsContext, jobMaster);
        this.mPersistRunner = new PersistRunner(this.mFsContext, jobMaster);
    }

    public CmdJobTracker(FileSystemContext fsContext, DistLoadCliRunner distLoadCliRunner, MigrateCliRunner migrateCliRunner, PersistRunner persistRunner) {
        this.mFsContext = fsContext;
        this.mDistLoadCliRunner = distLoadCliRunner;
        this.mMigrateCliRunner = migrateCliRunner;
        this.mPersistRunner = persistRunner;
    }

    public synchronized void run(CmdConfig cmdConfig, long jobControlId) throws JobDoesNotExistException, IOException {
        this.runDistributedCommand(cmdConfig, jobControlId);
    }

    private void runDistributedCommand(CmdConfig cmdConfig, long jobControlId) throws JobDoesNotExistException, IOException {
        CmdInfo cmdInfo;
        switch (cmdConfig.getOperationType()) {
            case DIST_LOAD: {
                LoadCliConfig loadCliConfig = (LoadCliConfig)cmdConfig;
                int batchSize = loadCliConfig.getBatchSize();
                AlluxioURI filePath = new AlluxioURI(loadCliConfig.getFilePath());
                int replication = loadCliConfig.getReplication();
                Set workerSet = loadCliConfig.getWorkerSet();
                Set excludedWorkerSet = loadCliConfig.getExcludedWorkerSet();
                Set localityIds = loadCliConfig.getLocalityIds();
                Set excludedLocalityIds = loadCliConfig.getExcludedLocalityIds();
                boolean directCache = loadCliConfig.getDirectCache();
                cmdInfo = this.mDistLoadCliRunner.runDistLoad(batchSize, filePath, replication, workerSet, excludedWorkerSet, localityIds, excludedLocalityIds, directCache, jobControlId);
                break;
            }
            case DIST_CP: {
                MigrateCliConfig migrateCliConfig = (MigrateCliConfig)cmdConfig;
                AlluxioURI srcPath = new AlluxioURI(migrateCliConfig.getSource());
                AlluxioURI dstPath = new AlluxioURI(migrateCliConfig.getDestination());
                LOG.info("run a dist cp command, cmd config is " + cmdConfig);
                cmdInfo = this.mMigrateCliRunner.runDistCp(srcPath, dstPath, migrateCliConfig.getOverWrite(), migrateCliConfig.getBatchSize(), jobControlId);
                break;
            }
            case PERSIST: {
                PersistCmdConfig persistCmdConfig = (PersistCmdConfig)cmdConfig;
                cmdInfo = this.mPersistRunner.runPersistJob(persistCmdConfig, jobControlId);
                break;
            }
            default: {
                throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{cmdConfig.getName()}));
            }
        }
        this.mInfoMap.put(cmdInfo.getJobControlId(), cmdInfo);
    }

    public Status getCmdStatus(long jobControlId) throws JobDoesNotExistException {
        if (!this.mInfoMap.containsKey(jobControlId)) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobControlId}));
        }
        CmdInfo cmdInfo = this.mInfoMap.get(jobControlId);
        if (cmdInfo.getCmdRunAttempt().isEmpty()) {
            return Status.COMPLETED;
        }
        int completed = 0;
        boolean finished = true;
        boolean failed = false;
        boolean canceled = false;
        for (CmdRunAttempt attempt : cmdInfo.getCmdRunAttempt()) {
            Status s = attempt.checkJobStatus();
            if (!s.isFinished()) {
                finished = false;
                break;
            }
            if (!failed && s == Status.FAILED) {
                failed = true;
                attempt.printFailed();
            }
            if (!canceled && s == Status.CANCELED) {
                canceled = true;
            }
            if (s != Status.COMPLETED) continue;
            ++completed;
        }
        if (finished) {
            if (failed) {
                return Status.FAILED;
            }
            if (canceled) {
                return Status.CANCELED;
            }
            if (completed == cmdInfo.getCmdRunAttempt().size()) {
                return Status.COMPLETED;
            }
        }
        return Status.RUNNING;
    }

    public Set<Long> findCmdIds(List<Status> statusList) throws JobDoesNotExistException {
        HashSet<Long> set = new HashSet<Long>();
        for (Map.Entry<Long, CmdInfo> x : this.mInfoMap.entrySet()) {
            if (!statusList.isEmpty() && !statusList.contains(this.getCmdStatus(x.getValue().getJobControlId()))) continue;
            Long key = x.getKey();
            set.add(key);
        }
        return set;
    }

    public Set<String> findAllFailedPaths() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<Long, CmdInfo> x : this.mInfoMap.entrySet()) {
            long jobControlId = x.getKey();
            try {
                set.addAll(this.findFailedPaths(jobControlId));
            }
            catch (JobDoesNotExistException e) {
                LOG.info("skip because of no such a command id.");
            }
        }
        return set;
    }

    public Set<String> findFailedPaths(long jobControlId) throws JobDoesNotExistException {
        if (!this.mInfoMap.containsKey(jobControlId)) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobControlId}));
        }
        CmdInfo cmdInfo = this.mInfoMap.get(jobControlId);
        if (cmdInfo.getCmdRunAttempt().isEmpty()) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobControlId}));
        }
        return cmdInfo.getCmdRunAttempt().stream().map(CmdRunAttempt::getFailedFiles).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public CmdStatusBlock getCmdStatusBlock(long jobControlId) throws JobDoesNotExistException {
        if (!this.mInfoMap.containsKey(jobControlId)) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobControlId}));
        }
        CmdInfo cmdInfo = this.mInfoMap.get(jobControlId);
        if (cmdInfo.getCmdRunAttempt().isEmpty()) {
            return new CmdStatusBlock(cmdInfo.getJobControlId(), Collections.EMPTY_LIST, cmdInfo.getOperationType());
        }
        List blockList = cmdInfo.getCmdRunAttempt().stream().map(attempt -> new SimpleJobStatusBlock(attempt.getJobId().longValue(), attempt.checkJobStatus(), attempt.getFilePath(), String.join((CharSequence)DELIMITER, attempt.getFailedFiles()))).collect(Collectors.toList());
        return new CmdStatusBlock(cmdInfo.getJobControlId(), blockList, cmdInfo.getOperationType());
    }
}

