/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.common;

import alluxio.grpc.OperationType;
import alluxio.job.wire.JobSource;
import alluxio.master.job.tracker.CmdRunAttempt;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.commons.compress.utils.Lists;

public class CmdInfo {
    private final long mJobControlId;
    private final List<CmdRunAttempt> mCmdRunAttempt;
    private final OperationType mOperationType;
    private final JobSource mJobSource;
    private final long mJobSubmissionTime;
    private final List<String> mFilePath;

    public CmdInfo(long jobControlId, OperationType operationType, JobSource jobSource, long jobSubmissionTime, List<String> filePath) {
        this.mJobControlId = jobControlId;
        this.mOperationType = operationType;
        this.mJobSource = jobSource;
        this.mJobSubmissionTime = jobSubmissionTime;
        this.mFilePath = filePath;
        this.mCmdRunAttempt = Lists.newArrayList();
    }

    public void addCmdRunAttempt(CmdRunAttempt attempt) {
        this.mCmdRunAttempt.add(attempt);
    }

    public List<CmdRunAttempt> getCmdRunAttempt() {
        return this.mCmdRunAttempt;
    }

    public long getJobControlId() {
        return this.mJobControlId;
    }

    public OperationType getOperationType() {
        return this.mOperationType;
    }

    public JobSource getJobSource() {
        return this.mJobSource;
    }

    public long getJobSubmissionTime() {
        return this.mJobSubmissionTime;
    }

    public List<String> getFilePath() {
        return this.mFilePath;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobControlId", this.mJobControlId).add("operationType", (Object)this.mOperationType).add("jobSource", (Object)this.mJobSource).add("submission time", this.mJobSubmissionTime).add("attempts", this.mCmdRunAttempt).toString();
    }
}

