/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.RpcUtils;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.CancelPRequest;
import alluxio.grpc.CancelPResponse;
import alluxio.grpc.GetAllWorkerHealthPRequest;
import alluxio.grpc.GetAllWorkerHealthPResponse;
import alluxio.grpc.GetCmdStatusDetailedRequest;
import alluxio.grpc.GetCmdStatusDetailedResponse;
import alluxio.grpc.GetCmdStatusRequest;
import alluxio.grpc.GetCmdStatusResponse;
import alluxio.grpc.GetJobServiceSummaryPRequest;
import alluxio.grpc.GetJobServiceSummaryPResponse;
import alluxio.grpc.GetJobStatusDetailedPRequest;
import alluxio.grpc.GetJobStatusDetailedPResponse;
import alluxio.grpc.GetJobStatusPRequest;
import alluxio.grpc.GetJobStatusPResponse;
import alluxio.grpc.JobMasterClientServiceGrpc;
import alluxio.grpc.ListAllPRequest;
import alluxio.grpc.ListAllPResponse;
import alluxio.grpc.RunPRequest;
import alluxio.grpc.RunPResponse;
import alluxio.grpc.SubmitRequest;
import alluxio.grpc.SubmitResponse;
import alluxio.job.CmdConfig;
import alluxio.job.JobConfig;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.master.job.JobMaster;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMasterClientServiceHandler
extends JobMasterClientServiceGrpc.JobMasterClientServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(JobMasterClientServiceHandler.class);
    private final JobMaster mJobMaster;

    public JobMasterClientServiceHandler(JobMaster jobMaster) {
        Preconditions.checkNotNull((Object)((Object)jobMaster));
        this.mJobMaster = jobMaster;
    }

    public void cancel(CancelPRequest request, StreamObserver<CancelPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            this.mJobMaster.cancel(request.getJobId());
            return CancelPResponse.getDefaultInstance();
        }, (String)"cancel", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getJobStatus(GetJobStatusPRequest request, StreamObserver<GetJobStatusPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetJobStatusPResponse.newBuilder().setJobInfo(this.mJobMaster.getStatus(request.getJobId(), false).toProto()).build(), (String)"getJobStatus", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getJobStatusDetailed(GetJobStatusDetailedPRequest request, StreamObserver<GetJobStatusDetailedPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetJobStatusDetailedPResponse.newBuilder().setJobInfo(this.mJobMaster.getStatus(request.getJobId(), true).toProto()).build(), (String)"getJobStatusDetailed", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getJobServiceSummary(GetJobServiceSummaryPRequest request, StreamObserver<GetJobServiceSummaryPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetJobServiceSummaryPResponse.newBuilder().setSummary(this.mJobMaster.getSummary().toProto()).build(), (String)"getJobServiceSummary", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void listAll(ListAllPRequest request, StreamObserver<ListAllPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            List<Long> jobList = this.mJobMaster.list(request.getOptions());
            ListAllPResponse.Builder builder = ListAllPResponse.newBuilder().addAllJobIds(jobList);
            if (!request.getOptions().hasJobIdOnly() || !request.getOptions().getJobIdOnly()) {
                for (Long id : jobList) {
                    builder.addJobInfos(this.mJobMaster.getStatus(id).toProto());
                }
            }
            return builder.build();
        }, (String)"listAll", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void run(RunPRequest request, StreamObserver<RunPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            try {
                byte[] jobConfigBytes = request.getJobConfig().toByteArray();
                return RunPResponse.newBuilder().setJobId(this.mJobMaster.run((JobConfig)SerializationUtils.deserialize((byte[])jobConfigBytes))).build();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentException((Throwable)e);
            }
        }, (String)"run", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getAllWorkerHealth(GetAllWorkerHealthPRequest request, StreamObserver<GetAllWorkerHealthPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            GetAllWorkerHealthPResponse.Builder builder = GetAllWorkerHealthPResponse.newBuilder();
            List<JobWorkerHealth> workerHealths = this.mJobMaster.getAllWorkerHealth();
            for (JobWorkerHealth workerHealth : workerHealths) {
                builder.addWorkerHealths(workerHealth.toProto());
            }
            return builder.build();
        }, (String)"getAllWorkerHealth", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void submit(SubmitRequest request, StreamObserver<SubmitResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            try {
                byte[] cmdConfigBytes = request.getCmdConfig().toByteArray();
                return SubmitResponse.newBuilder().setJobControlId(this.mJobMaster.submit((CmdConfig)SerializationUtils.deserialize((byte[])cmdConfigBytes))).build();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentException((Throwable)e);
            }
        }, (String)"Submit", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getCmdStatus(GetCmdStatusRequest request, StreamObserver<GetCmdStatusResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetCmdStatusResponse.newBuilder().setCmdStatus(this.mJobMaster.getCmdStatus(request.getJobControlId()).toProto()).build(), (String)"GetCmdStatus", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void getCmdStatusDetailed(GetCmdStatusDetailedRequest request, StreamObserver<GetCmdStatusDetailedResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetCmdStatusDetailedResponse.newBuilder().setCmdStatusBlock(this.mJobMaster.getCmdStatusDetailed(request.getJobControlId()).toProto()).build(), (String)"getCmdStatusDetailed", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }
}

