/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.RestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.master.AlluxioJobMasterProcess;
import alluxio.util.LogUtils;
import alluxio.wire.AlluxioJobMasterInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(value="/job_master", description="Job Master Rest Service")
@Path(value="job_master")
@Produces(value={"application/json"})
@NotThreadSafe
public final class AlluxioJobMasterRestServiceHandler {
    public static final String SERVICE_PREFIX = "job_master";
    public static final String LOG_LEVEL = "logLevel";
    public static final String LOG_ARGUMENT_NAME = "logName";
    public static final String LOG_ARGUMENT_LEVEL = "level";
    public static final String GET_INFO = "info";
    public static final String QUERY_RAW_CONFIGURATION = "raw_configuration";
    private final AlluxioJobMasterProcess mJobMaster;

    public AlluxioJobMasterRestServiceHandler(@Context ServletContext context) {
        this.mJobMaster = (AlluxioJobMasterProcess)((Object)context.getAttribute("Alluxio Job Master"));
    }

    @GET
    @Path(value="info")
    @ApiOperation(value="Get general job master service information", response=AlluxioJobMasterInfo.class)
    public Response getInfo(@ApiParam(value="Returns raw configuration values if true, false be default.") @QueryParam(value="raw_configuration") Boolean rawConfiguration) {
        return RestUtils.call(() -> {
            boolean rawConfig = false;
            if (rawConfiguration != null) {
                rawConfig = rawConfiguration;
            }
            AlluxioJobMasterInfo result = new AlluxioJobMasterInfo().setConfiguration(this.getConfigurationInternal(rawConfig)).setStartTimeMs(this.mJobMaster.getStartTimeMs()).setUptimeMs(this.mJobMaster.getUptimeMs()).setVersion("2.9.0").setWorkers(this.mJobMaster.getJobMaster().getWorkerInfoList());
            return result;
        }, (AlluxioConfiguration)Configuration.global());
    }

    @POST
    @Path(value="logLevel")
    public Response logLevel(@QueryParam(value="logName") String logName, @QueryParam(value="level") String level) {
        return RestUtils.call(() -> LogUtils.setLogLevel((String)logName, (String)level), (AlluxioConfiguration)Configuration.global());
    }

    private Map<String, Object> getConfigurationInternal(boolean raw) {
        if (raw) {
            return Configuration.toMap((ConfigurationValueOptions)ConfigurationValueOptions.defaults().useRawValue(raw));
        }
        return Configuration.toMap();
    }
}

