/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.JournalDomain;
import alluxio.master.AbstractMaster;
import alluxio.master.AlluxioSimpleMasterProcess;
import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.PrimarySelector;
import alluxio.master.job.JobMaster;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.master.journal.ufs.UfsJournalSingleMasterPrimarySelector;
import alluxio.underfs.JobUfsManager;
import alluxio.underfs.UfsManager;
import alluxio.util.CommonUtils;
import alluxio.util.URIUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.JobMasterWebServer;
import alluxio.web.WebServer;
import com.google.common.base.Preconditions;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioJobMasterProcess
extends AlluxioSimpleMasterProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobMasterProcess.class);
    protected JobMaster mJobMaster;

    AlluxioJobMasterProcess(JournalSystem journalSystem, PrimarySelector leaderSelector) {
        super("job", JournalDomain.JOB_MASTER, journalSystem, leaderSelector, NetworkAddressUtils.ServiceType.JOB_MASTER_WEB, NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, PropertyKey.JOB_MASTER_HOSTNAME);
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        FileSystem fileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
        JobUfsManager ufsManager = new JobUfsManager();
        try {
            this.mJobMaster = new JobMaster(new MasterContext(this.mJournalSystem, null, (UfsManager)ufsManager), fileSystem, fsContext, (UfsManager)ufsManager);
        }
        catch (Exception e) {
            LOG.error("Failed to create job master", (Throwable)e);
            throw new RuntimeException("Failed to create job master", e);
        }
    }

    AbstractMaster getAbstractMaster() {
        return this.mJobMaster;
    }

    public <T extends Master> T getMaster(Class<T> clazz) {
        if (clazz == JobMaster.class) {
            return (T)((Object)this.mJobMaster);
        }
        throw new RuntimeException(String.format("Could not find the master: %s", clazz));
    }

    public JobMaster getJobMaster() {
        return this.mJobMaster;
    }

    WebServer createWebServer() {
        return new JobMasterWebServer(NetworkAddressUtils.ServiceType.JOB_MASTER_WEB.getServiceName(), this.mWebBindAddress, this);
    }

    GrpcServerBuilder createBaseRPCServer() {
        return GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)this.mRpcConnectAddress.getHostName(), (SocketAddress)this.mRpcBindAddress), (AlluxioConfiguration)Configuration.global()).flowControlWindow((int)Configuration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_FLOWCONTROL_WINDOW)).keepAliveTime(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).keepAliveTimeout(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIMEOUT_MS), TimeUnit.MILLISECONDS).permitKeepAlive(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_PERMIT_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).maxInboundMessageSize((int)Configuration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
    }

    @ThreadSafe
    static final class Factory {
        public static AlluxioJobMasterProcess create() {
            URI journalLocation = JournalUtils.getJournalLocation();
            JournalSystem journalSystem = new JournalSystem.Builder().setLocation(URIUtils.appendPathOrDie((URI)journalLocation, (String)"JobJournal")).build(CommonUtils.ProcessType.JOB_MASTER);
            if (Configuration.getBoolean((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED)) {
                Preconditions.checkState((!(journalSystem instanceof RaftJournalSystem) ? 1 : 0) != 0, (Object)"Raft journal cannot be used with Zookeeper enabled");
                PrimarySelector primarySelector = PrimarySelector.Factory.createZkJobPrimarySelector();
                return new AlluxioJobMasterProcess(journalSystem, primarySelector);
            }
            if (journalSystem instanceof RaftJournalSystem) {
                PrimarySelector primarySelector = ((RaftJournalSystem)journalSystem).getPrimarySelector();
                return new AlluxioJobMasterProcess(journalSystem, primarySelector);
            }
            return new AlluxioJobMasterProcess(journalSystem, (PrimarySelector)new UfsJournalSingleMasterPrimarySelector());
        }

        private Factory() {
        }
    }
}

