/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.parquet;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.job.plan.transform.format.JobPath;
import alluxio.job.plan.transform.format.ReadWriterUtils;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.TableWriter;
import alluxio.job.plan.transform.format.parquet.ParquetRow;
import alluxio.job.plan.transform.format.parquet.ParquetSchema;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParquetWriter
implements TableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetWriter.class);
    private static final int MAX_IN_MEMORY_RECORDS = 10000;
    private static final int ROW_GROUP_SIZE = 0x8000000;
    private static final String DEFAULT_COMPRESSION_CODEC = CompressionCodecName.SNAPPY.name();
    private final org.apache.parquet.hadoop.ParquetWriter<GenericData.Record> mWriter;
    private long mRecordSize;
    private int mRows;

    private ParquetWriter(org.apache.parquet.hadoop.ParquetWriter<GenericData.Record> writer) {
        this.mWriter = writer;
    }

    public static ParquetWriter create(TableSchema schema, AlluxioURI uri) throws IOException {
        return ParquetWriter.create(schema, uri, 0x8000000, true, DEFAULT_COMPRESSION_CODEC);
    }

    public static ParquetWriter create(TableSchema schema, AlluxioURI uri, @Nullable PartitionInfo partitionInfo) throws IOException {
        String compressionCodec = DEFAULT_COMPRESSION_CODEC;
        if (partitionInfo != null) {
            compressionCodec = partitionInfo.getSerdeProperties().getOrDefault("file.parquet.compression", DEFAULT_COMPRESSION_CODEC);
        }
        return ParquetWriter.create(schema, uri, 0x8000000, true, compressionCodec);
    }

    public static ParquetWriter create(TableSchema schema, AlluxioURI uri, int rowGroupSize, boolean enableDictionary) throws IOException {
        return ParquetWriter.create(schema, uri, rowGroupSize, enableDictionary, DEFAULT_COMPRESSION_CODEC);
    }

    public static ParquetWriter create(TableSchema schema, AlluxioURI uri, int rowGroupSize, boolean enableDictionary, String compressionCodec) throws IOException {
        Configuration conf = ReadWriterUtils.writeThroughConf();
        ParquetSchema parquetSchema = schema.toParquet();
        return new ParquetWriter((org.apache.parquet.hadoop.ParquetWriter<GenericData.Record>)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)HadoopOutputFile.fromPath((Path)new JobPath(uri.getScheme(), uri.getAuthority().toString(), uri.getPath()), (Configuration)conf)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).withConf(conf)).withCompressionCodec(CompressionCodecName.fromConf((String)compressionCodec))).withRowGroupSize(rowGroupSize)).withDictionaryPageSize(0x100000)).withDictionaryEncoding(enableDictionary)).withPageSize(0x100000)).withDataModel(GenericData.get()).withSchema(parquetSchema.getSchema()).build());
    }

    @Override
    public void write(TableRow row) throws IOException {
        ParquetRow parquetRow = row.toParquet();
        this.mWriter.write((Object)parquetRow.getRecord());
        ++this.mRows;
        if (this.mRows == 1) {
            this.mRecordSize = this.mWriter.getDataSize();
        }
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }

    @Override
    public int getRows() {
        return this.mRows;
    }

    @Override
    public long getBytes() {
        return Math.max(0L, this.mWriter.getDataSize() - Math.max(0x8000000L, 10000L * this.mRecordSize));
    }
}

