/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.csv;

import alluxio.collections.Pair;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decimal {
    private static final Logger LOG = LoggerFactory.getLogger(Decimal.class);
    private final int mPrecision;
    private final int mScale;

    public Decimal(String type) {
        Pair<Integer, Integer> precisionAndScale = Decimal.getPrecisionAndScale(type);
        this.mPrecision = (Integer)precisionAndScale.getFirst();
        this.mScale = (Integer)precisionAndScale.getSecond();
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public int getScale() {
        return this.mScale;
    }

    public static Pair<Integer, Integer> getPrecisionAndScale(String type) {
        type = type.trim();
        String param = type.substring(8, type.length() - 1);
        String[] params = param.split(",");
        return new Pair((Object)Integer.parseInt(params[0].trim()), (Object)Integer.parseInt(params[1].trim()));
    }

    public BigDecimal toBigDecimal(String v) {
        int pointIndex = v.indexOf(46);
        int fractionLen = 0;
        if (pointIndex != -1) {
            fractionLen = v.length() - pointIndex - 1;
        } else {
            v = v + ".";
        }
        v = fractionLen >= this.mScale ? v.substring(0, v.length() - (fractionLen - this.mScale)) : StringUtils.rightPad((String)v, (int)(v.length() + (this.mScale - fractionLen)), (char)'0');
        return new BigDecimal(v);
    }

    public byte[] toParquetBytes(String v) {
        return this.toBigDecimal(v).unscaledValue().toByteArray();
    }
}

