/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.csv;

import alluxio.job.plan.transform.FieldSchema;
import alluxio.job.plan.transform.HiveConstants;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.csv.CsvSchema;
import alluxio.job.plan.transform.format.csv.CsvUtils;
import alluxio.job.plan.transform.format.csv.Decimal;
import alluxio.job.plan.transform.format.parquet.ParquetRow;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Base64;
import javax.validation.constraints.NotNull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvRow
implements TableRow {
    private static final Logger LOG = LoggerFactory.getLogger(CsvRow.class);
    private final CsvSchema mSchema;
    private final GenericData.Record mRecord;

    public CsvRow(@NotNull CsvSchema schema, @NotNull GenericData.Record record) {
        this.mSchema = (CsvSchema)Preconditions.checkNotNull((Object)schema, (Object)"schema");
        this.mRecord = (GenericData.Record)Preconditions.checkNotNull((Object)record, (Object)"record");
    }

    @Override
    public Object getColumn(String column) {
        return this.mRecord.get(column);
    }

    @Override
    public ParquetRow toParquet() throws IOException {
        Schema writeSchema = this.mSchema.getWriteSchema();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(writeSchema);
        for (FieldSchema field : this.mSchema.getAlluxioSchema()) {
            String name = field.getName();
            String type = field.getType();
            Object value = this.mRecord.get(name);
            value = this.convert(value, name, type);
            recordBuilder.set(writeSchema.getField(name), value);
        }
        return new ParquetRow(recordBuilder.build());
    }

    private Object convert(Object value, String name, String type) throws IOException {
        if (!CsvUtils.isReadWriteTypeInconsistent(type)) {
            return value;
        }
        String v = (String)value;
        switch (HiveConstants.Types.getHiveConstantType((String)type)) {
            case "decimal": {
                Decimal decimal = new Decimal(type);
                return decimal.toParquetBytes(v);
            }
            case "binary": {
                return Base64.getDecoder().decode(v.getBytes(StandardCharsets.UTF_8));
            }
            case "date": {
                try {
                    return LocalDate.parse(v).toEpochDay();
                }
                catch (Throwable e) {
                    throw new IOException("Failed to parse '" + v + "' as DATE: " + e);
                }
            }
            case "timestamp": {
                try {
                    return Timestamp.valueOf(v).getTime();
                }
                catch (Throwable e) {
                    throw new IOException("Failed to parse '" + v + "' as TIMESTAMP: " + e);
                }
            }
        }
        throw new IOException("Unsupported type " + type + " for field " + name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvRow)) {
            return false;
        }
        CsvRow that = (CsvRow)o;
        return Objects.equal((Object)this.mRecord, (Object)that.mRecord) && Objects.equal((Object)this.mSchema, (Object)that.mSchema);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mRecord, this.mSchema});
    }
}

