/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.MoveBlockRequest;
import alluxio.job.RunTaskContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.AbstractVoidPlanDefinition;
import alluxio.job.plan.replicate.MoveConfig;
import alluxio.job.util.SerializableVoid;
import alluxio.resource.CloseableResource;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MoveDefinition
extends AbstractVoidPlanDefinition<MoveConfig, SerializableVoid> {
    private static final Logger LOG = LoggerFactory.getLogger(MoveDefinition.class);

    @Override
    public Class<MoveConfig> getJobConfigClass() {
        return MoveConfig.class;
    }

    @Override
    public Set<Pair<WorkerInfo, SerializableVoid>> selectExecutors(MoveConfig config, List<WorkerInfo> jobWorkerInfoList, SelectExecutorsContext context) {
        Preconditions.checkArgument((!jobWorkerInfoList.isEmpty() ? 1 : 0) != 0, (Object)"No worker is available");
        String workerHost = config.getWorkerHost();
        HashSet result = Sets.newHashSet();
        Collections.shuffle(jobWorkerInfoList);
        for (WorkerInfo workerInfo : jobWorkerInfoList) {
            if (!workerHost.equals(workerInfo.getAddress().getHost())) continue;
            result.add(new Pair((Object)workerInfo, null));
            return result;
        }
        return result;
    }

    @Override
    public SerializableVoid runTask(MoveConfig config, SerializableVoid args, RunTaskContext context) throws Exception {
        long blockId = config.getBlockId();
        String localHostName = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)Configuration.global());
        List workerInfoList = context.getFsContext().getCachedWorkers();
        WorkerNetAddress localNetAddress = null;
        for (BlockWorkerInfo workerInfo : workerInfoList) {
            if (!workerInfo.getNetAddress().getHost().equals(localHostName)) continue;
            localNetAddress = workerInfo.getNetAddress();
            break;
        }
        if (localNetAddress == null) {
            String message = String.format("Cannot find a local block worker to move block %d", blockId);
            throw new NotFoundException(message);
        }
        MoveBlockRequest request = MoveBlockRequest.newBuilder().setBlockId(blockId).setMediumType(config.getMediumType()).build();
        try (CloseableResource blockWorker = context.getFsContext().acquireBlockWorkerClient(localNetAddress);){
            ((BlockWorkerClient)blockWorker.get()).moveBlock(request);
        }
        return null;
    }
}

