/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.task;

import alluxio.exception.JobDoesNotExistException;
import alluxio.grpc.RunTaskCommand;
import alluxio.job.JobConfig;
import alluxio.job.RunTaskContext;
import alluxio.job.plan.PlanDefinition;
import alluxio.job.plan.PlanDefinitionRegistry;
import alluxio.job.util.SerializationUtils;
import alluxio.worker.job.task.TaskExecutorManager;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TaskExecutor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutor.class);
    private final long mJobId;
    private final long mTaskId;
    private final RunTaskCommand mRunTaskCommand;
    private final RunTaskContext mContext;
    private final TaskExecutorManager mTaskExecutorManager;

    public TaskExecutor(long jobId, long taskId, RunTaskCommand runTaskCommand, RunTaskContext context, TaskExecutorManager taskExecutorManager) {
        this.mJobId = jobId;
        this.mTaskId = taskId;
        this.mRunTaskCommand = runTaskCommand;
        this.mContext = (RunTaskContext)Preconditions.checkNotNull((Object)context);
        this.mTaskExecutorManager = (TaskExecutorManager)Preconditions.checkNotNull((Object)taskExecutorManager);
    }

    @Override
    public void run() {
        Serializable result;
        PlanDefinition<JobConfig, Serializable, Serializable> definition;
        JobConfig jobConfig = null;
        Serializable taskArgs = null;
        try {
            jobConfig = (JobConfig)SerializationUtils.deserialize((byte[])this.mRunTaskCommand.getJobConfig().toByteArray());
            if (this.mRunTaskCommand.hasTaskArgs()) {
                taskArgs = SerializationUtils.deserialize((byte[])this.mRunTaskCommand.getTaskArgs().toByteArray());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.fail(e, jobConfig, null);
        }
        try {
            definition = PlanDefinitionRegistry.INSTANCE.getJobDefinition(jobConfig);
        }
        catch (JobDoesNotExistException e) {
            LOG.error("The job definition for config {} does not exist.", (Object)jobConfig.getName());
            this.fail(e, jobConfig, taskArgs);
            return;
        }
        this.mTaskExecutorManager.notifyTaskRunning(this.mJobId, this.mTaskId);
        try {
            result = definition.runTask(jobConfig, taskArgs, this.mContext);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable t) {
            this.fail(t, jobConfig, taskArgs);
            return;
        }
        this.mTaskExecutorManager.notifyTaskCompletion(this.mJobId, this.mTaskId, result);
    }

    private void fail(Throwable t, JobConfig jobConfig, Serializable taskArgs) {
        this.mTaskExecutorManager.notifyTaskFailure(this.mJobId, this.mTaskId, t);
        LOG.warn("Exception running task for job {}({}) : {}", new Object[]{jobConfig == null ? "Undefined" : jobConfig.getName(), taskArgs == null ? "Undefined" : taskArgs.toString(), t.getMessage()});
    }
}

