/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.task;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private boolean mIsPaused = false;
    private int mNumPaused = 0;
    private ReentrantLock mPauseLock = new ReentrantLock();
    private Condition mUnpaused = this.mPauseLock.newCondition();

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public int getNumActiveTasks() {
        this.mPauseLock.lock();
        try {
            int n = super.getActiveCount() - this.mNumPaused;
            return n;
        }
        finally {
            this.mPauseLock.unlock();
        }
    }

    public void pause() {
        this.mPauseLock.lock();
        try {
            this.mIsPaused = true;
        }
        finally {
            this.mPauseLock.unlock();
        }
    }

    public void resume() {
        this.mPauseLock.lock();
        try {
            if (this.mIsPaused) {
                this.mIsPaused = false;
                this.mUnpaused.signalAll();
            }
        }
        finally {
            this.mPauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.mPauseLock.lock();
        try {
            ++this.mNumPaused;
            while (this.mIsPaused) {
                this.mUnpaused.await();
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
        }
        finally {
            --this.mNumPaused;
            this.mPauseLock.unlock();
        }
    }
}

