/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.command;

import alluxio.util.CommonUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class JobWorkerHealthReporter {
    private static final Logger LOG = LoggerFactory.getLogger(JobWorkerHealthReporter.class);
    private static final double CPU_LOAD_AVERAGE_HEALTHY_FACTOR = 1.0;
    private HardwareAbstractionLayer mHardware = new SystemInfo().getHardware();
    private List<Double> mCpuLoadAverage;
    private int mLogicalProcessorCount;
    private long mLastComputed;

    public List<Double> getCpuLoadAverage() {
        return this.mCpuLoadAverage;
    }

    public boolean isHealthy() {
        if (this.mCpuLoadAverage.isEmpty()) {
            return true;
        }
        return (double)this.mLogicalProcessorCount * 1.0 > this.mCpuLoadAverage.get(0);
    }

    public void compute() {
        this.mLastComputed = CommonUtils.getCurrentMs();
        this.mCpuLoadAverage = DoubleStream.of(this.mHardware.getProcessor().getSystemLoadAverage(3)).boxed().collect(Collectors.toList());
        this.mLogicalProcessorCount = this.mHardware.getProcessor().getLogicalProcessorCount();
    }
}

