/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.exception.ConnectionFailedException;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClient;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JobWorkerIdRegistry {
    public static final long INVALID_WORKER_ID = 0L;
    private static AtomicLong sWorkerId = new AtomicLong(0L);

    private JobWorkerIdRegistry() {
    }

    public static void registerWorker(JobMasterClient jobMasterClient, WorkerNetAddress workerAddress) throws IOException, ConnectionFailedException {
        sWorkerId.set(jobMasterClient.registerWorker(workerAddress));
    }

    public static Long getWorkerId() {
        return sWorkerId.get();
    }
}

