/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.ClientContext;
import alluxio.Server;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.ConnectionFailedException;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.job.JobServerContext;
import alluxio.metrics.MetricsSystem;
import alluxio.security.user.ServerUserState;
import alluxio.underfs.UfsManager;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AbstractWorker;
import alluxio.worker.JobWorkerIdRegistry;
import alluxio.worker.job.JobMasterClient;
import alluxio.worker.job.JobMasterClientContext;
import alluxio.worker.job.command.CommandHandlingExecutor;
import alluxio.worker.job.task.TaskExecutorManager;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JobWorker
extends AbstractWorker {
    private static final Logger LOG = LoggerFactory.getLogger(JobWorker.class);
    private final JobServerContext mJobServerContext;
    private final JobMasterClient mJobMasterClient;
    private TaskExecutorManager mTaskExecutorManager;
    private Future<?> mCommandHandlingService;

    JobWorker(FileSystem filesystem, FileSystemContext fsContext, UfsManager ufsManager) {
        super(ExecutorServiceFactories.fixedThreadPool((String)"job-worker-executor", (int)1));
        this.mJobServerContext = new JobServerContext(filesystem, fsContext, ufsManager);
        this.mJobMasterClient = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)ServerConfiguration.global())).build());
    }

    public Set<Class<? extends Server>> getDependencies() {
        return new HashSet<Class<? extends Server>>();
    }

    public String getName() {
        return "JobWorker";
    }

    public Map<ServiceType, GrpcService> getServices() {
        return Collections.emptyMap();
    }

    public void start(WorkerNetAddress address) throws IOException {
        super.start(address);
        MetricsSystem.startSinks((String)ServerConfiguration.get((PropertyKey)PropertyKey.METRICS_CONF_FILE));
        try {
            JobWorkerIdRegistry.registerWorker(this.mJobMasterClient, address);
        }
        catch (ConnectionFailedException e) {
            LOG.error("Failed to connect to job master", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        this.mTaskExecutorManager = new TaskExecutorManager(ServerConfiguration.getInt((PropertyKey)PropertyKey.JOB_WORKER_THREADPOOL_SIZE), address);
        this.mCommandHandlingService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Job Worker Command Handling", (HeartbeatExecutor)new CommandHandlingExecutor(this.mJobServerContext, this.mTaskExecutorManager, this.mJobMasterClient, address), (long)((int)ServerConfiguration.getMs((PropertyKey)PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL)), (AlluxioConfiguration)ServerConfiguration.global(), ServerUserState.global()));
    }

    public void stop() throws IOException {
        if (this.mCommandHandlingService != null) {
            this.mCommandHandlingService.cancel(true);
        }
        this.mJobMasterClient.close();
        super.stop();
    }
}

