/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.security.user.ServerUserState;
import alluxio.security.user.UserState;
import alluxio.underfs.JobUfsManager;
import alluxio.underfs.UfsManager;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.JobWorkerWebServer;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.JobWorker;
import alluxio.worker.JobWorkerIdRegistry;
import alluxio.worker.JobWorkerProcess;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AlluxioJobWorkerProcess
implements JobWorkerProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobWorkerProcess.class);
    private final FileSystem mFileSystem;
    private final FileSystemContext mFsContext;
    private JobWorker mJobWorker;
    private int mRPCPort;
    private GrpcServer mGrpcServer;
    private ServerSocket mBindSocket;
    private InetSocketAddress mRpcConnectAddress;
    private InetSocketAddress mRpcBindAddress;
    private long mStartTimeMs;
    private JobWorkerWebServer mWebServer = null;
    private UfsManager mUfsManager;

    AlluxioJobWorkerProcess() {
        try {
            this.mFsContext = FileSystemContext.create((AlluxioConfiguration)ServerConfiguration.global());
            this.mFileSystem = FileSystem.Factory.create((FileSystemContext)this.mFsContext);
            this.mStartTimeMs = System.currentTimeMillis();
            this.mUfsManager = new JobUfsManager();
            this.mJobWorker = new JobWorker(this.mFileSystem, this.mFsContext, this.mUfsManager);
            this.mWebServer = new JobWorkerWebServer(NetworkAddressUtils.ServiceType.JOB_WORKER_WEB.getServiceName(), NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_WEB, (AlluxioConfiguration)ServerConfiguration.global()), this);
            InetSocketAddress configuredBindAddress = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global());
            if (configuredBindAddress.getPort() == 0) {
                this.mBindSocket = new ServerSocket(0);
                this.mRPCPort = this.mBindSocket.getLocalPort();
            } else {
                this.mRPCPort = configuredBindAddress.getPort();
            }
            ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_RPC_PORT, (Object)Integer.toString(this.mRPCPort));
            this.mRpcBindAddress = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global());
            this.mRpcConnectAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global());
        }
        catch (Exception e) {
            LOG.error("Failed to create JobWorkerProcess", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public InetSocketAddress getRpcAddress() {
        return this.mRpcConnectAddress;
    }

    @Override
    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    @Override
    public long getUptimeMs() {
        return System.currentTimeMillis() - this.mStartTimeMs;
    }

    @Override
    public InetSocketAddress getWebAddress() {
        if (this.mWebServer != null) {
            return new InetSocketAddress(this.mWebServer.getBindHost(), this.mWebServer.getLocalPort());
        }
        return null;
    }

    public boolean waitForReady(int timeoutMs) {
        try {
            CommonUtils.waitFor((String)(this + " to start"), () -> this.isServing() && this.mWebServer != null && this.mWebServer.getServer().isRunning(), (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public void start() throws Exception {
        this.mWebServer.start();
        this.startWorkers();
        LOG.info("Started {} with id {}", (Object)this, (Object)JobWorkerIdRegistry.getWorkerId());
        LOG.info("Alluxio job worker version {} started. bindHost={}, connectHost={}, rpcPort={}, webPort={}", new Object[]{"2.7.3", NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global()), NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global()), NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global()), NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_WEB, (AlluxioConfiguration)ServerConfiguration.global())});
        this.startServingRPCServer();
        LOG.info("Alluxio job worker ended");
    }

    private void startServingRPCServer() {
        try {
            if (this.mBindSocket != null) {
                this.mBindSocket.close();
            }
            LOG.info("Starting gRPC server on address {}", (Object)this.mRpcConnectAddress);
            GrpcServerBuilder serverBuilder = GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)this.mRpcConnectAddress.getHostName(), (SocketAddress)this.mRpcBindAddress), (AlluxioConfiguration)ServerConfiguration.global(), (UserState)ServerUserState.global());
            for (Map.Entry<ServiceType, GrpcService> serviceEntry : this.mJobWorker.getServices().entrySet()) {
                LOG.info("Registered service:{}", (Object)serviceEntry.getKey().name());
                serverBuilder.addService(serviceEntry.getValue());
            }
            this.mGrpcServer = serverBuilder.build().start();
            LOG.info("Started gRPC server on address {}", (Object)this.mRpcConnectAddress);
            this.mGrpcServer.awaitTermination();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isServing() {
        return this.mGrpcServer != null && this.mGrpcServer.isServing();
    }

    public void stop() throws Exception {
        LOG.info("Stopping RPC server on {} @ {}", (Object)this, (Object)this.mRpcConnectAddress);
        if (this.isServing()) {
            this.stopServing();
            this.stopWorkers();
        }
    }

    @Override
    public WorkerNetAddress getAddress() {
        return new WorkerNetAddress().setHost(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.JOB_WORKER_RPC, (AlluxioConfiguration)ServerConfiguration.global())).setContainerHost(ServerConfiguration.global().getOrDefault(PropertyKey.WORKER_CONTAINER_HOSTNAME, "")).setRpcPort(ServerConfiguration.getInt((PropertyKey)PropertyKey.JOB_WORKER_RPC_PORT)).setDataPort(ServerConfiguration.getInt((PropertyKey)PropertyKey.JOB_WORKER_DATA_PORT)).setWebPort(ServerConfiguration.getInt((PropertyKey)PropertyKey.JOB_WORKER_WEB_PORT));
    }

    private void startWorkers() throws Exception {
        this.mJobWorker.start(this.getAddress());
    }

    private void stopWorkers() throws Exception {
        this.mJobWorker.stop();
    }

    private void stopServing() {
        if (this.isServing() && !this.mGrpcServer.shutdown()) {
            LOG.warn("RPC server shutdown timed out.");
        }
        try {
            this.mWebServer.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop web server", (Throwable)e);
        }
    }

    public String toString() {
        return "Alluxio job worker";
    }
}

