/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.Process;
import alluxio.ProcessUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.user.ServerUserState;
import alluxio.security.user.UserState;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.worker.JobWorkerProcess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AlluxioJobWorker {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobWorker.class);

    public static void main(String[] args) {
        JobWorkerProcess process;
        if (args.length != 0) {
            LOG.info("java -cp {} {}", (Object)"target/alluxio-2.7.3-jar-with-dependencies.jar", (Object)AlluxioJobWorker.class.getCanonicalName());
            System.exit(-1);
        }
        if (!ConfigurationUtils.masterHostConfigured((AlluxioConfiguration)ServerConfiguration.global())) {
            System.out.println(ConfigurationUtils.getMasterHostNotConfiguredMessage((String)"Alluxio job worker"));
            System.exit(1);
        }
        if (!ConfigurationUtils.jobMasterHostConfigured((AlluxioConfiguration)ServerConfiguration.global())) {
            System.out.println(ConfigurationUtils.getJobMasterHostNotConfiguredMessage((String)"Alluxio job worker"));
            System.exit(1);
        }
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.JOB_WORKER);
        MasterInquireClient masterInquireClient = MasterInquireClient.Factory.create((AlluxioConfiguration)ServerConfiguration.global(), (UserState)ServerUserState.global());
        try {
            RetryUtils.retry((String)"load cluster default configuration with master", () -> {
                InetSocketAddress masterAddress = masterInquireClient.getPrimaryRpcAddress();
                ServerConfiguration.loadWorkerClusterDefaults((InetSocketAddress)masterAddress);
            }, (RetryPolicy)RetryUtils.defaultWorkerMasterClientRetry((Duration)ServerConfiguration.getDuration((PropertyKey)PropertyKey.WORKER_MASTER_CONNECT_RETRY_TIMEOUT)));
        }
        catch (IOException e) {
            ProcessUtils.fatalError((Logger)LOG, (String)"Failed to load cluster default configuration for job worker. Please make sure that Alluxio master is running: %s", (Object[])new Object[]{e.toString()});
        }
        try {
            process = JobWorkerProcess.Factory.create();
        }
        catch (Throwable t) {
            ProcessUtils.fatalError((Logger)LOG, (Throwable)t, (String)"Failed to create job worker process", (Object[])new Object[0]);
            throw t;
        }
        ProcessUtils.stopProcessOnShutdown((Process)process);
        ProcessUtils.run((Process)process);
    }

    private AlluxioJobWorker() {
    }
}

