/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.metrics;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.job.JobConfig;
import alluxio.job.plan.BatchedJobConfig;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.retry.RetryPolicy;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCmdMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedCmdMetrics.class);
    private static final Counter JOB_DISTRIBUTED_LOAD_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_SUCCESS.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FAIL.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_CANCEL.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FILE_COUNT.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FILE_SIZE.getName());
    private static final Meter JOB_DISTRIBUTED_LOAD_RATE = MetricsSystem.meter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_RATE.getName());
    private static final Counter MIGRATE_JOB_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_SUCCESS.getName());
    private static final Counter MIGRATE_JOB_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FAIL.getName());
    private static final Counter MIGRATE_JOB_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_CANCEL.getName());
    private static final Counter MIGRATE_JOB_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FILE_COUNT.getName());
    private static final Counter MIGRATE_JOB_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName());
    private static final Counter ASYNC_PERSIST_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_SUCCESS.getName());
    private static final Counter ASYNC_PERSIST_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FAIL.getName());
    private static final Counter ASYNC_PERSIST_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_CANCEL.getName());
    private static final Counter ASYNC_PERSIST_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_COUNT.getName());
    private static final Counter ASYNC_PERSIST_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName());

    public static void incrementOperationCount(String jobType, long count) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_SUCCESS.inc(count);
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_SUCCESS.inc(count);
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_SUCCESS.inc(count);
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementFileCount(String jobType, long count) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_FILE_COUNT.inc(count);
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_FILE_COUNT.inc(count);
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_FILE_COUNT.inc(count);
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementFileSize(String jobType, long fileSize) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_FILE_SIZE.inc(fileSize);
                JOB_DISTRIBUTED_LOAD_RATE.mark(fileSize);
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_FILE_SIZE.inc(fileSize);
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_FILE_SIZE.inc(fileSize);
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementForFailStatus(String jobType) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_FAIL.inc();
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_FAIL.inc();
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_FAIL.inc();
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementForCancelStatus(String jobType) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_CANCEL.inc();
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_CANCEL.inc();
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_CANCEL.inc();
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementForCompleteStatusWithRetry(JobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        String jobType = config.getName();
        String filePath = DistributedCmdMetrics.getFilePathForNonBatchConfig(config);
        DistributedCmdMetrics.incrementOperationCount(jobType, 1L);
        DistributedCmdMetrics.incrementFileCount(jobType, 1L);
        while (retryPolicy.attempt()) {
            try {
                long fileSize = fileSystem.getStatus(new AlluxioURI(filePath)).getLength();
                DistributedCmdMetrics.incrementFileSize(jobType, fileSize);
                break;
            }
            catch (AlluxioException | IOException | RuntimeException e) {
                LOG.warn("Retry getStatus for URI {} for {}-th time, {}", new Object[]{filePath, retryPolicy.getAttemptCount(), Arrays.toString(e.getStackTrace())});
            }
        }
    }

    private static String getFilePathForNonBatchConfig(JobConfig config) {
        String path = null;
        if (config instanceof LoadConfig) {
            path = ((LoadConfig)config).getFilePath();
        } else if (config instanceof MigrateConfig) {
            path = ((MigrateConfig)config).getSource();
        } else if (config instanceof PersistConfig) {
            path = ((PersistConfig)config).getFilePath();
        }
        return path;
    }

    public static void batchIncrementForCompleteStatusWithRetry(BatchedJobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        String jobType = config.getJobType();
        long count = config.getJobConfigs().size();
        DistributedCmdMetrics.incrementOperationCount(jobType, count);
        DistributedCmdMetrics.incrementFileCount(jobType, count);
        String pathMapKey = null;
        if (jobType.equals("Migrate")) {
            pathMapKey = "source";
        } else if (jobType.equals("Load") || jobType.equals("Persist")) {
            pathMapKey = "filePath";
        }
        String finalPathMapKey = pathMapKey;
        config.getJobConfigs().forEach(jobConfig -> {
            while (retryPolicy.attempt()) {
                try {
                    long fileSize = fileSystem.getStatus(new AlluxioURI((String)jobConfig.get(finalPathMapKey))).getLength();
                    DistributedCmdMetrics.incrementFileSize(jobType, fileSize);
                    break;
                }
                catch (AlluxioException | IOException e) {
                    LOG.warn("Retry getStatus for URI {} for {}-th time, {}", new Object[]{finalPathMapKey, retryPolicy.getAttemptCount(), Arrays.toString(e.getStackTrace())});
                }
                catch (RuntimeException e) {
                    LOG.warn("Null key is found for config map with key = {}, more info is {}", (Object)finalPathMapKey, (Object)Arrays.toString(e.getStackTrace()));
                    break;
                }
            }
        });
    }

    public static void batchIncrementForFailStatus(BatchedJobConfig config) {
        String jobType = config.getJobType();
        config.getJobConfigs().forEach(jobConfig -> DistributedCmdMetrics.incrementForFailStatus(jobType));
    }

    public static void batchIncrementForCancelStatus(BatchedJobConfig config) {
        String jobType = config.getJobType();
        config.getJobConfigs().forEach(jobConfig -> DistributedCmdMetrics.incrementForCancelStatus(jobType));
    }

    public static void incrementForAllConfigsCompleteStatus(JobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForCompleteStatusWithRetry((BatchedJobConfig)config, fileSystem, retryPolicy);
        } else {
            DistributedCmdMetrics.incrementForCompleteStatusWithRetry(config, fileSystem, retryPolicy);
        }
    }

    public static void incrementForAllConfigsCancelStatus(JobConfig config) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForCancelStatus((BatchedJobConfig)config);
        } else {
            DistributedCmdMetrics.incrementForCancelStatus(config.getName());
        }
    }

    public static void incrementForAllConfigsFailStatus(JobConfig config) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForFailStatus((BatchedJobConfig)config);
        } else {
            DistributedCmdMetrics.incrementForFailStatus(config.getName());
        }
    }
}

