/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.command;

import alluxio.grpc.CancelTaskCommand;
import alluxio.grpc.JobCommand;
import alluxio.grpc.RunTaskCommand;
import alluxio.grpc.SetTaskPoolSizeCommand;
import alluxio.job.JobConfig;
import alluxio.job.util.SerializationUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CommandManager {
    private static final Logger LOG = LoggerFactory.getLogger(CommandManager.class);
    private final Map<Long, List<JobCommand>> mWorkerIdToPendingCommands = Maps.newHashMap();

    public synchronized void submitRunTaskCommand(long jobId, long taskId, JobConfig jobConfig, Object taskArgs, long workerId) {
        RunTaskCommand.Builder runTaskCommand = RunTaskCommand.newBuilder();
        runTaskCommand.setJobId(jobId);
        runTaskCommand.setTaskId(taskId);
        try {
            runTaskCommand.setJobConfig(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig)));
            if (taskArgs != null) {
                runTaskCommand.setTaskArgs(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)taskArgs)));
            }
        }
        catch (IOException e) {
            LOG.info("Failed to serialize the run task command:" + e);
            return;
        }
        JobCommand.Builder command = JobCommand.newBuilder();
        command.setRunTaskCommand(runTaskCommand);
        this.submit(workerId, command);
    }

    public synchronized void submitCancelTaskCommand(long jobId, long taskId, long workerId) {
        CancelTaskCommand.Builder cancelTaskCommand = CancelTaskCommand.newBuilder();
        cancelTaskCommand.setJobId(jobId);
        cancelTaskCommand.setTaskId(taskId);
        JobCommand.Builder command = JobCommand.newBuilder();
        command.setCancelTaskCommand(cancelTaskCommand);
        this.submit(workerId, command);
    }

    public synchronized void submitSetTaskPoolSizeCommand(long workerId, int taskPoolSize) {
        SetTaskPoolSizeCommand.Builder setTaskPoolSizeCommand = SetTaskPoolSizeCommand.newBuilder();
        setTaskPoolSizeCommand.setTaskPoolSize(taskPoolSize);
        JobCommand.Builder command = JobCommand.newBuilder();
        command.setSetTaskPoolSizeCommand(setTaskPoolSizeCommand);
        this.submit(workerId, command);
    }

    private synchronized void submit(long workerId, JobCommand.Builder command) {
        if (!this.mWorkerIdToPendingCommands.containsKey(workerId)) {
            this.mWorkerIdToPendingCommands.put(workerId, Lists.newArrayList());
        }
        this.mWorkerIdToPendingCommands.get(workerId).add(command.build());
    }

    public synchronized List<JobCommand> pollAllPendingCommands(long workerId) {
        if (!this.mWorkerIdToPendingCommands.containsKey(workerId)) {
            return Lists.newArrayList();
        }
        ArrayList commands = Lists.newArrayList((Iterable)this.mWorkerIdToPendingCommands.get(workerId));
        this.mWorkerIdToPendingCommands.get(workerId).clear();
        return commands;
    }
}

